/*
 * Decompiled with CFR 0.152.
 */
package korlibs.template.internal;

import korlibs.template.internal.Hex;
import korlibs.template.internal.IntExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0007\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\b*\u00020\u0001H\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u000e\u0010\u000f\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\"\u001a\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0010"}, d2={"quoted", "", "getQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "unquoted", "getUnquoted", "escape", "isPrintable", "", "", "isQuoted", "quote", "uescape", "unescape", "unquote", "uquote", "korte"})
public final class StringEscapeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrintable(char $this$isPrintable) {
        boolean bl;
        if (' ' <= $this$isPrintable) {
            if ($this$isPrintable < '\u007f') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('\u00a1' > $this$isPrintable) return false;
        if ($this$isPrintable >= '\u0100') return false;
        return true;
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape) {
        StringBuilder out = new StringBuilder();
        int n = $this$escape.length();
        for (int n2 = 0; n2 < n; ++n2) {
            char c = $this$escape.charAt(n2);
            char c2 = c;
            if (c2 == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c2 == '\n') {
                out.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                out.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                out.append("\\t");
                continue;
            }
            boolean bl = '\u0000' <= c2 ? c2 < ' ' : false;
            if (bl) {
                out.append("\\x");
                out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 4, 4)));
                out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 0, 4)));
                continue;
            }
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String uescape(@NotNull String $this$uescape) {
        StringBuilder out = new StringBuilder();
        int n = $this$uescape.length();
        for (int n2 = 0; n2 < n; ++n2) {
            char c = $this$uescape.charAt(n2);
            char c2 = c;
            if (c2 == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c2 == '\n') {
                out.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                out.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                out.append("\\t");
                continue;
            }
            if (StringEscapeKt.isPrintable(c)) {
                out.append(c);
                continue;
            }
            out.append("\\u");
            out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 12, 4)));
            out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 8, 4)));
            out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 4, 4)));
            out.append(Hex.INSTANCE.encodeCharLower(IntExtKt.extract(c, 0, 4)));
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        StringBuilder out = new StringBuilder();
        int n = 0;
        while (n < $this$unescape.length()) {
            char c;
            if ((c = $this$unescape.charAt(n++)) == '\\') {
                char c2;
                char c3;
                if ((c3 = (c2 = $this$unescape.charAt(n++))) == '\\') {
                    out.append('\\');
                    continue;
                }
                if (c3 == '\"') {
                    out.append('\"');
                    continue;
                }
                if (c3 == 'n') {
                    out.append('\n');
                    continue;
                }
                if (c3 == 'r') {
                    out.append('\r');
                    continue;
                }
                if (c3 == 't') {
                    out.append('\t');
                    continue;
                }
                if (c3 == 'u') {
                    String chars;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$unescape.substring(n, n + 4), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    n += 4;
                    out.append((char)Integer.parseInt(chars, CharsKt.checkRadix((int)16)));
                    continue;
                }
                out.append("" + '\\' + c2);
                continue;
            }
            out.append(c);
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String uquote(@Nullable String $this$uquote) {
        return $this$uquote != null ? '\"' + StringEscapeKt.uescape($this$uquote) + '\"' : "null";
    }

    @NotNull
    public static final String quote(@Nullable String $this$quote) {
        return $this$quote != null ? '\"' + StringEscapeKt.escape($this$quote) + '\"' : "null";
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        return StringsKt.startsWith$default((CharSequence)$this$isQuoted, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$isQuoted, (char)'\"', (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote) {
        String string;
        if (StringEscapeKt.isQuoted($this$unquote)) {
            String string2 = $this$unquote.substring(1, $this$unquote.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = StringEscapeKt.unescape(string2);
        } else {
            string = $this$unquote;
        }
        return string;
    }

    @NotNull
    public static final String getQuoted(@Nullable String $this$quoted) {
        return StringEscapeKt.quote($this$quoted);
    }

    @NotNull
    public static final String getUnquoted(@NotNull String $this$unquoted) {
        return StringEscapeKt.unquote($this$unquoted);
    }
}

