﻿RFX - a simple high level abstraction for guiding  the creation of automatically generated parameter interfaces.

The RFX (originally this stood for Rendered Effects) standard is designed to simplify the creation and customisation of
auto-generated parameter interfaces, in particular the type of interface used by a host application to set the parameters
for a variety of plugins. The protocol described is not directed specifically toward any particular graphical toolset,
    rather it provides a higher level abstraction which may then be rendered using standard components of the toolset.

    Furthermore, the design of the protocol is modular; the major components (parameters, parameter window, triggers)
    are designed to work in harmony but each may also be used independently, providing flexibilty to the application
    developer whilst minimising the need to duplicate code for vary classes of plugins.

---------------------------------

Author: salsaman+lives@gmail.com
Last edit date: 06 June 2020
API Version: 1.8.4 GNU FDL

Changes
1.0 First version salsaman@xs4all.nl
1.1 Added input channels
1.2 Added "<author>" section
1.3 Added "<define>" section
1.4 Added string support, made line delimiter fixed (\n)
1.5 Added note about LC_NUMERIC
d1.6 Added string_list parameter type
1.7 Updates for compatibility with realtime effects
1.8 Add special multirect, deprecate multrect, and remove audiochannel.

--- API Major / Minor Version frozen ---

- Add "special|framedraw|multirect|"; add some hints about interpreting "special" keyword in "<layout>"
- Add "special|framedraw|singlepoint|"
- multirect -> multrect, fix description of it.
- Add missing "label" field for string (documentation error)
- Correct "language code"
- Added "batch generator" flag bit + explanation of generators.
- Describe how width and height are passed back to host.
- Add "special|fileread"
- Added note about differing input image types
- Add "special|password"
- Fix text errors, add note about "$fps"
- Clarify max length for fileread special keyword.
- tighten up wording a little bit
- Correct description of "multirect", remove mention of "multrect"

1.8.1
- Add "special|filewrite"
- License amended to LGPL to allow its use in closed source components.

1.8.2
- Add "special|scaledpoint"

1.8.3
- in LiVES-perl, values of width and height now set in $width, $height rather than $nwidth, $nheight.

1.8.4 Add special|fontchooser

- clarified the meaning of "min frames"



TODO: 	- split into RFX layout and RFX plugin components (?)



Note:
This license documents a standard. The license of this document is the GNU FDL (GNU Free Documentation License)
version 1.3 or higher. 
The reference implementations are released under the LGPL v3 or higher.

See: http://www.gnu.org/copyleft/fdl.html
https://www.gnu.org/licenses/lgpl-3.0.en.html



1. Introduction
     
RFX is a system for generating parameter windows and plugins, e.g. rendered 
effects from scripts. It currently has features for:

- defining parameters
- sending layout hints to a GUI about how to present a parameter window
- allowing triggers when the parameter window is initialised, and/or when any of the parameter values are altered

An addendum to the generic RFX standard may be used to provide the following:
- allowing definition of code for pre/loop/post processing (where loop may be applied a number of times determined by the
							    application)


Note: The first 3 parts are generic for any type of plugin;
the final part is application specific and not neccesary for general usage.


The system described year has been in use succesfully in the LiVES application
for over 10 years with only very minor changes needed (clarifications and a handful
of "special" type additions). It has succesfully been employed for a wide range
of plugin types: video effects, audio effects, video decoders, encoders




----------------------------------------------------------------------


RFX layout is now intended to be a standalone component which can be used for passing parameter window descriptions 
between applications.

The script itself is divided into sections. The only required sections are  <define> and <name>; the latter is simply used to enable
differentiation betweem scripts and may be autogenerated randomly if required.

Other optional sections are:
<params>				- may be used to declare the number and type of parameters to be displayed as well as
							some implementation details (min, max, default value for example)
<param_window>			- may be used customise the layout of auto generated graphical interfaces
<language_code>			- this section is optional but must be present if <onchange> is present, determines the
							specific (computational) language use in that section
<onchange>				- an optional section which uses simple scripting to update the value, min, or max of paramters
							 depending on inital conditions or value changes of other parameters

The <language_code> may also be used to define a scripting language to be used and permit plugins to be *generated* from
an RFX script. In this case the remaining option sections <pre>. <loop>, and <post> may also be used to generate a more
complete standalone unit which can the be run independently. This was the original intended purpose of RFX, however it
proved convenient to use combinations of the other sections within pre-compiled plugins.

The the below was written with the intention of describing the entire process of generating a plugin and defining its
parameters and interface layout.

In fact any of the sections may be used independently, and those parts of the description which refer to other
script sections should be ignored.


--------------------------------------------------------------------



2. RFX Scripts


The following section describes a full RFX script, and the rules which must be 
implemented in order to comply with the RFX script version 1.8


NOTE: for RFX, the shell variable LC_NUMERIC should be set to "C"; that implies the radix character for 
numeric values is "."


Scripts
------------

Scripts are the beginning point for all effects/tools/utilities in RFX.
From the script, an interface and or plugin can be generated for a particular host 
application. The details of the plugin generation are left to the authors of 
the relevant host applications. RFX script files are abstracted in the sense 
that they are not tied to any particular widget set, or to any particular 
method of transferring data between host and plugin.

The function of the plugin is to return the data in each section as requested by the host. If applicable, it
should also execute the code in the relevant code sections <onchange>, <pre>, <post>, <loop>.
One may think of a builder tool which
takes a script and generates a plugin, which the host can then load and use.
For example there is the build_lives_rfx_plugin tool for the LiVES video editor
which can generate an executable Perl plugin from a full RFX script.

The function of the host is to build an interface as defined by either the parameters, parameter_window sections, or by combining both.
The host should then run this parameter window and marshall the parameters back to the plugin.

Some RFX scripts may use only the parameter_window and the other mandatory sections.




Here are the sections (some mandatory, some optional) which comprise an RFX 
script file. Each section in the script file is laid out as follows:

<keyword>
value1
value2
</keyword>

some keyword sections are optional, these are indicated below as:
<keyword> [optional]

some keyword sections take a single data value, some take multiple data values
Keywords which take multiple values are indicated thus:
<keyword> [list]

In the case of multiple values, each value should be terminated by a newline 
(\n) character.

Within values, the delimiter is '|'. A trailing delimiter in a line is generally ignored, but can be added 
for readability (as in some of the examples below).

Note:
As of RFX version 1.4, the field delimiter is set in the <define>
section. However, the default value is assumed below.

The field delimiter must be a single (ASCII) character. It may not be \0 or \n.

The sections marked [plugins only] are only used when the script is being used to *generate* a plugin.

Here are the RFX sections:

<define>

<name>

<version> [plugins only]

<author> [plugins only]

<description> [plugins only]

<requires> [optional] [plugins only] [list]

<params> [optional] [list]

<param_window> [optional] [list]

<properties> [plugins only] [optional]

<language_code>

<pre> [plugins only] [optional] [list] 

<loop> [plugins only] [optional] [list] 

<post> [plugins only] [optional] [list] 

<onchange> [optional] [list]

The contents of each section are described below. Note that the sections may be in any order in the script, however it is
more readable if the ordering below is adopted.


=== HEADER SECTIONS ===

<define>

This mandatory section contains the following entities:
field delimiter
RFX version

E.g.:

<define>
|1.8.4
</define>

The first character following the newline after <define> is the delimiter. This is followed (without any intervening characters or
	     whitespace) by the lowest RFX version the script is compatible with
We shall assume for the purposes of this description that the delimiter is the character '|'
The format of the version is the standard dotted <major>.<minor>.<micro>

NOTE: the following sections apply only when a plugin is to  be generated from the script.
The sections beginning with <params> are more relevant for pre-generated plugins.

NOTE: in the following sctions, where "free text" is used, the format of the text is UTF8, unless specifically noted otherwise.


<name>

This section is mandatory for generated plugins, and contains a single entry with the name of the script. The name 
not contain spaces, newlines or the delimiter character (|). Each plugin name should be unique for that author.


e.g.

<name>
blank_frames
</name>




<version>

This is a mandatory section for generated; = a version string for a plugin. It should be an integer. 
This is NOT the same thing as the RFX version in the <define> section.

e.g.

<version>
1
</version>

<author>

This is a mandatory section for generating, an "author" string for a plugin. Tje format is free text,
but it may not contain newline or the  delimiter character. An optional second field may contain the author's URL.

e.g.

<author>
somebody@somewhere.com|http://www.mysite.org|
</author>



<description>

This section consists of a single entry with 4 fields, it is mandatory for generated plugins:

menu text|action description|minimum frames|num_channels

e.g.

<description>
Edge Detect|Edge detecting|1|1
</description>

minimum frames is defined as follows:
a value of -1 indicates a plugin which does not deal with video at all
This type of plugin is designated a 'utility', an example being the frame_calculator

a value of 0 denotes a plugin that is "stateless", i.e each frame is processed in
the exact same way, regardless of its order in the sequence

a value of 1 indiocates that the plugin updates some internal variables
for each frame in a sequence

		  a va;ue of 2 or higher
		  denotes a plugin which  makes use of the pixel data from
		  prior or evren future  frames"

For generators a value of 0 for min frames indicates that all generated images
    are identical copies of each other.

    a value of 1 indicates that the output frames vary and

    a value of 2 or higher
    indicates a "batch" generetar which simply produces a number of frames without
    providing anny indication as to its progress.




num_channels indicates the number of input channels. (LiVES currently will only 
accept 0,1, or 2 input channels).


IMPORTANT NOTE
A value of -1 for minimum frames indicates that the plugin will not actually 
process frames. This is useful for plugins where only a parameter window is 
needed. In the case that minimum frames is -1, the host application should 
simply display the parameter window and allow the user to change the values, 
but no processing of frames should be performed. This is useful with trigger 
code for tools like calculators.




<requires> [optional] [list]

This section consists of a list of required binaries for the generated  plugin to run. 
Each entry in the list should be separated by a newline.

e.g.

<requires>
convert
composite
</requires>

The host and/or plugin will check that the required binaries are present in the user's $PATH
before attempting to process any frames.



=== PARAMETER SECTIONS ===


<params> [optional] [list]

This section contains a list of parameters the plugin would like to receive from the host. Each entry in the 
list should be separated by a newline. Each entry in the list contains a 
variable number of fields depending on the parameter Type.

The name of each parameter should be unique within the plugin.


The types which are defined at the time of the current version  are:

num
bool
colRGB24
string
string_list

Each type is defined thus:

num: this is a numeric value. The 'num' type is immediately followed by a 
decimal number indicating the number of decimal places. An integer value is 
therefore declared as 'num0', while a numerical value with 6 decimal places of 
accuracy is declared as 'num6'.

The parameter format for a num is as follows:
parameter_name|label|type|default|minimum|maximum|step_size/wrap|


NOTE
An underscore in the label text usually indicates that the following character is a
mnemonic accelerator for the parameter. In case the host does not support 
mnemonic accelerators, underscores may be excluded from the label text by the host.
The text itself should be in UTF-8 format.


The step size is the amount that the value is adjusted by
for example when the arrows are clicked on a spinbutton representing this parameter.
    A negative step_size means that the parameter values should wrap (max to min and min to max). In this case
    the actual step size is give by taking the positive value of the number.

e.g.

<params>
rotate|_Rotate selection by|num0|360|-3600|3600|
</params>

The decimal separate is '.' As noted earlier, on Posix systems, LC_NUMERIC may be set to "C" to help ensure this.


bool: this indicates a boolean parameter
The format for this parameter type is:

parameter_name|label|type|default|group|

e.g.

<params>
shrink|_Shrink rotated window to fit frame size|bool|0|0|
</params>

The default should be constrained to the values 0 (FALSE) and 1 (TRUE).

The group field is an optional integer. If it is non-zero then this indicates a radio button group.
That is, for all boolean parameters in the 
plugin which have the same group, only one may take a value of 1 (TRUE). 





colRGB24: this indicates a 24 bit RGB value. The leftmost 8 bits correspond to 
red, the next 8 bits to green, and the rightmost 8 bits to blue.

The format for this parameter type is:
parameter_name|label|type|default_red|default_green|default_blue|

e.g.
<params>
startcol|_Start colour|colRGB24|255|255|255|
</params>




string: this indicates a string parameter

The format for this parameter type is:

parameter_name|label|type|default|max_length_in_utf-8_chars|

The default may not contain the field delimiter character, however it may contain newlines. The encoding used is UTF-8.


max_length is measured in utf-8 characters. It is an optional field, and if omitted,
the maximum string length for the "language_code" will be used whenedver applicable.
e.g.

<params>
text|Enter some _text|string|The default value is "default".\nThis is line 2|1024|
</params>



string_list: this indicates a list of string parameters, from which exactly one entry may be selected
The format for this parameter type is:

parameter_name|label|type|default|first_string|second_string|...

No string may contain the field delimiter character, but the strings may contain newlines.



The default is an index into the list of strings. 0 means the first string, 1 means the second, etc.
The value returned will be an integer.

e.g.

<params>
method|Choose a _method|string_list|0|method1|method2|method3|
</params>


Because of the ambiguity with trailing field delimeters, the last string in the list may not be empty.
Empty strings are however, allowed at all other positions in the list.

There is no requirement that the value be with the bounds of list. The behaviour in this case is undefined
The intention is, therefore that the value should equate to a valid position in the list.





RFX Interface Section
---------------------



<param_window> [optional] [list]

This section is used to provide layout hints to the host about how to draw a 
parameter window for this effect/tool.

The format is a list of layout hints separated by newlines. Each line in the 
list has a keyword followed by one or more subfields separated by "|"

Two keywords are currently supported:

layout
special


layout is hint to the host about how to present a parameter interface to a human
user. It is abstracted from any particular widget set.

It is up to the host how each layout line in this section is actually 
interpreted. The design is kept as simple as possible to allow for the actual
visual appearance to be liberally interpreted.
 
However,
the suggested way to picture this is to imagine that each layout line
describes a horizontal
box, with the boxes arranged in order from top to bottom within an interface window.
Any remaining parameters would then be appended below this, within the same window.

Other interpetations may be used if so desired, or the hints may be ignored
altogether.

IT IS, HOWEVER, HIGHLY recommended that the "password" hint is acted upon since
it may be desirable to obscure the text, keep it secure, etc.




=== LAYOUT ===

The layout keyword may be followed by 0 or more fields which describe a layout row.
the fields can be:

px == position of parameter x on the screen. The first parameter is p0, the second is p1, etc.

The mapping of numbering to parameters may be taken from the
<parameter> section.

or they may defined elsewhere.


fill == fill with blank space. Multple "fill"s may be used sequentially, or the fill keyword may be immediately followed by an integer
number, e.g fill4 would indicate 4 fills. The actual fill size is
determined by the host. However for a visually pleasing effect it is recommended
that the size is chosen so that parameters are aligned vertically in sequential rows.

"label" == a label

hseparator == horizontal line separator


Example:

<param_window>
layout|p0|"This is a label"|
layout|p5|
layout|p1|fill|p2|
layout|hseparator|
layout|p3|fill|
layout|p4|fill|
</param_window>

This can be interpreted as:
layout row 0:  parameter 0 followed by a label with text "This is a label"
layout row 1:  paramter 5
layout row 2: paramter 1, blank space, parameter 2
layout row 3: horizontal separator
layout row 4: parameter 3, blank space
layout row 5: parameter 4, blank space

Blank space at the end would likely indicate that the parameter should be pushed to the start of the layout row,
rather than expanding fill it all.


=== SPECIAL ===

A second keyword which can be used in the param_window section is "special".
This indicates to the host some information about the role of a parameter or
set of parameters. The host may then use this information to better present that
role to the user.

"special" is then followed by the TYPE of the special widget, and for some types this must be followed by a SUBTYPE. The list of TYPES and SUBTYPES is deliberately kept
small.

After the type and subtype the indices of the "linked" parameters appear. The amount (or amounts) of linked parameters is determined
by the special type and subtype as defined below. In some cases the linked parameters may take multiple values,
then it is up to the developers to determine which if any subset of values are
     "current"
     i.e. represented in the user interface at any one time.


Example:

special|framedraw|rectdemask|1|2|3|4

this line would provide a hint that a special role with TYPE framedraw, and SUBTYPE
rectdemask (rectangular demask) may be linked to parameters 1, 2, 3, and 4
Note it does not provide any POSITIONAL information regarding the link parameters.
That role is reserved only for "layout" lines.

In view of this fact,  only the parameter numeration (starting from 0)
is used here, as opposed to p0, p1, p2 etc used in the layout lines
(thus the p prefix can be thought of as POSITION).

It is up to developers exactly how they visually interpret the special keyword.
It is however, STRONGLY recommended to use at most ONE of each special type per
interface window, since not all hosts may support multiple instances of a type.

Below are the suggested interpretations for each type / subtype.


=== TYPES ===


Special type "framedraw" - allows user drawing on a preview frame to control some parameters and vice-versa.

	Bear in mind that it is the host which is doing the drawing here.

	If a link parameters have 0 decimal places, then the value may be assumed to be in pixels.
	If more than 0 decimal places, the value is a ratio 
	where {0.0, 0,0} is the top left, {1.0,1.0} is the bottom right of the image, {1., 0.} is top right, etc.

	Subtype "rectdemask" - >= 4 numeric parameters : demask (only show) a region on the preview frame, from
	position p0[n],p1[n] to p2[n],p3[n]  [p2, p3 are absolute coordinates] More denerally, denotes "region of interest"
	within the frame.

	Subtype "multirect" - >= 4 numeric parameters : draw a rectangle (outline) on preview frame,
	offset p0[n]*out_channel0_width, p1[n]*out_channel0_height,
	scaled by p2[n]*out_channel0_width, p3[n]*out_channel0_height
	[p2, p3[ are relative values.
	
	Subtype "singlepoint" - >= 2 numeric parameters : draw a "target" point (e.g. crosshair) on the frame, at offset 
        p0[n],p1[n]

	Subtype "scaledpoint" - 3 numeric parameters : draw a "target" point (e.g. crosshair) on the frame at offset
	{p0 / p2, p1 / p2}, i.e p2 acts as a scaling / zoom factor. Conversly, if the point is moved on the screen, p0 and p1 should
	be altered by the (x, y) delta in screen pixels divided by p2.

					    
Special type "aspect" - 2 numeric parameters : p0 and p1 may be aspect ratio locked to the corresponding to some initial
                                       width and height; host should provide a way to select/deselect this

Special type "mergealign" – 2 parameters
The mergealign special widget links together two num type parameters.
It has two toggle states as well as a neutral state.
Toggling it one way should set the first parameter to its minimum value and the second parameter
to its maximum value. Toggling the other way will do the opposite, set the first parameter to its maximum,
and the second parameter to its minimum.

Special type "fileread" - 1 string parameter : the linked string parameter should point to a file to which the user has read permissions.
In this case the maximum string length may be ignored by the host if would result in truncating longer filenames.

Special type "filewrite" - 1 string parameter : the linked string parameter should point to a file to which the user has
write / create permissions. In this case the maximum string length may be ignored as with fileread.
The host may confirm with the user in the case that the file already exists as the existing file may be overwritten.

Special type "password" - 1 string parameter : the host may hide/obscure the input to this string. IT IS RECOMMENDED NOT TO IGNORE THIS HINT, FOR SECURITY CONSIDERATIONS.

Special type "fontchooser" - 1 string parameter, one numerical.  The first parameter may be set to a font name, the second to a font (point) size.


================================== end interface section ================================






<properties> [optional]

this is a bitmap field (currently 32 bit) for rendered effects. Hexadecimal values are allowed.
some bits are defined already

0x0001 == slow (hint to host)
0x0002 == may resize
0x0004 == batch mode generator
 [NB. this is equivalent to a min frames | channels setting of 2|0 (see above)]

If the "may resize" bit is set, _all_ frames in the processing block may be 
resized to a new width and height. The host should take measures to determine the new width / height of the output using its
standard discovery methods.


A "batch mode" generator is a plugin with 0 in channels, and which generates all frames in a single pass (i.e. the loop code is only to be run once).



0x8000 == reserved, may be ignored / set / reset.
0x4000 == reserved, may be ignored / set / reset.
0x2000 == reserved, may be ignored / set / reset.
0x1000 == reserved, may be ignored / set / reset.

If the value of properties is not defined, it is assumed to be 0x0000.



e.g.
<properties>
0x0001
</properties>




<language_code>

The language code indicates the scripting language for the <pre>, <loop>, 
<post> and <onchange> sections. This is a 32 bit unsigned integer. Hexadecimal values are allowed.

Current values are:

0xF0 == LiVES-perl




<pre> [optional] [list]

This section is for rendered effects and contains code which will be executed before the processing loop.

e.g. (in LiVES-perl):

<pre>
#calculate the number of frames
$length=$end-$start+1;
</pre>


For non-batch-mode generators using LiVES-perl, this section is mandatory, and you must set $end equal to the number of frames which will be generated, e.g.:

<pre>
$end=100;
</pre>

For batch mode or non-batch-mode generators, you can also set the frame rate for the clip (this is optional). In LiVES-perl, this is done by setting $fps (which can take a floating point value), e.g.

<pre>
$end=100;
$fps=25.0;
</pre>




<loop> [list]

IMPORTANT NOTE
This section is mandatory for rendered effect plugins (optional for non-processing scripts - where min frames is set 
to -1, see above)

This section contains code which will be executed for each frame in the 
processing block.

e.g. (in LiVES-perl):

<loop>
#negate each frame
system("$convert_command -negate $in $out");
</loop>


The rules for processing are as follows:

in each pass of the loop you should produce an output frame (possibly by using 
the input frame). For example, in LiVES-perl, the output frame is called $out.
The output frames should be created in numerical from the start of the 
processing block to the end in numerical order with no gaps. The image type 
should not be changed, nor should the palette. Frames may be resized provided 
the script has the "may resize" property bit set.

If no processing is to be done on a pass, then the input frame should be 
copied to the output frame.

An exception to this is if the plugin has no in channels, and set the "batch generator" flag bit. In this case, the loop code will be run *only once*, and the generator should create an alpha-numeric sequence of image files. If the plugin is a generator, and this flag bit is not set, the plugin should generate frame $out, and it should be of the correct type (e.g. jpeg if $out ends in .jpg) and all frames must be of the same width and height.

One further exception - if two or more input frames are to be merged into one output frame, the 
input frames may be of different types (for example, a png image and a jpeg image may be merged 
into a single png image). In this case, all input images should be converted to the first input 
image type before merging. The resulting output image should also be of the same type.



If the plugin sets the may-resize bit, or is a non-batch-mode generator, the width and height of the frames should be
passed back to the host.
In LiVES-perl this is done by setting $width and $height to the width and height in pixels, respectively.
(N.B. prior to 1.8.3 this was $nwidth and $nheight)


Plugins with no in channels (generators) may also set $fps to inform the host of the framerate of the 
generated clip.




<post> [optional] [list]

This section is for rendered effects only, and contains code which should be executed after all frames in the 
block have been processed.

e.g. (in LiVES-perl):

<post>
#clean up a temporary file
unlink "blank.jpg";
</post>




<onchange> [optional] [list]

This section contains the triggers for changing parameters either when the 
parameter window is first created, or when a parameter is changed. For example
 an init type trigger could set the maximum and minimum values for a parameter 
depending on the current frame width and height.

The format is:

event|code

event can be either "init" or an integer representing a parameter. The first 
parameter is given the number 0, the second parameter 1, etc.
There can be multiple lines of code for each type of change. Code for the same 
trigger type is executed in the order in which it appears in this section. The format of the code depends on the value of <language_code>.


e.g. (in LiVES-perl):

<onchange>
init|$p0_min=-$width+1; $p0_max=$width-1; $p1_min=-$height+1; $p1_max=$height-1;
0|if ($p0) {$p3=$p4*$p5;} elsif ($p1&&$p5>0.) {$p4=$p3/$p5;}
0| elsif ($p4>0.) {$p5=$p3/$p4;}
</onchange>




Examples:

1) setup window for openGL playback plugin:

const char *get_init_rfx(void) {
  return 
    "<define>\\n\
|1.7\\n\
</define>\\n\
<params> \\n\
mode|_Mode|string_list|0|Normal|Triangle|Rotating|Wobbler|Landscape|Insider|Cube|Turning|Tunnel|Particles|Dissolve\\n\
tfps|Max render _Framerate|num2|" SE(DEF_FPS_MAX) "|1.|200.\\n\
nbuf|Number of _texture buffers (ignored)|num0|" SE(DEF_NBUF) "|1|256\\n\
dbuf|Use _double buffering|bool|1|0\\n\
fsover|Over-ride _fullscreen setting (for debugging)|bool|0|0\\n\
</params> \\n\
";
}


2) Setup window for a simple encoder:

const char *get_init_rfx(void) {
    return
                    "<define>\\n\
|1.8.1\\n\
</define>\\n\
<language_code>\\n\
0xF0\\n\
</language_code>\\n\
<params> \\n\
form|_Format|string_list|0|mp4/h264/aac|ogm/theora/vorbis||\\n\
\
mbitv|Max bitrate (_video)|num0|3000000|100000|1000000000|\\n\
\
achans|Audio _layout|string_list|1|mono|stereo||\\n\
arate|Audio _rate (Hz)|string_list|1|22050|44100|48000||\\n\
mbita|Max bitrate (_audio)|num0|320000|16000|10000000|\\n\
\
fname|_Output file|string|| \\n\
</params> \\n\
<param_window> \\n\
special|filewrite|5| \\n\
layout|p5|| \\n\
</param_window> \\n\
<onchange> \\n\
init|$p5 = (split(/\\./,$p5))[0]; if ($p0 == 0) {$p5 .= \".mp4\";} else {$p5 .= \".ogm\";} \\n\
0|$p5 = (split(/\\./,$p5))[0]; if ($p0 == 0) {$p5 .= \".mp4\";} else {$p5 .= \".ogm\";} \\n\
</onchange> \\n\
";
}



		    
3) "negate" rendered effect, complete plugin script:

<define>
|1.7
</define>

<name>
negate
</name>

<version>
1
</version>

<author>
Salsaman|
</author>

<description>
Negate|Negating|1|1|
</description>

<requires>
convert
</requires>

<params>
neg|_Negate|num0|1|1|10000|
skip|_Skip|num0|0|0|10000|
</params>

<param_window>
layout|p0|"frames, then "|p1|"frames"|
</param_window>

<properties>
0x0000
</properties>

<language_code>
0xF0
</language_code>

<pre>
$to_do=$p0;
</pre>

<loop>
if ($to_do<=0) {
    if ($to_do<=-$p1) {
        $to_do=$p0;
    }
    else {
        #need continuous frames for preview
        `cp $in $out`;
    }
}
	 
if ($to_do>0) {
    system("$convert_command $img_prefix$in -negate $out_prefix$out");
}
$to_do--;
</loop>

<post>
</post>

<onchange>
init|$p1_max=$length-$p0; $p0_max=$length-$p1;
0|$p1_max=$length-$p0;
</onchange>
