.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_get_archive_comment.mdoc -- get zip archive comment
.\" Copyright (C) 2006-2021 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_GET_ARCHIVE_COMMENT" "3" "September 22, 2020" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_get_archive_comment\fR
\- get zip archive comment
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIconst char *\fR
.br
.PD 0
.HP 4n
\fBzip_get_archive_comment\fR(\fIzip_t\ *archive\fR, \fIint\ *lenp\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_get_archive_comment\fR()
function returns the comment for the entire zip archive.
The return value is in UTF-8 encoding unless
\fRZIP_FL_ENC_RAW\fR
was specified (see below).
This pointer should not be modified or
free(3)'d,
and becomes invalid when
\fIarchive\fR
is closed.
If
\fIlenp\fR
is not
\fRNULL\fR,
the integer to which it points will be set to the length of the
comment.
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged comment is returned.
.PP
Additionally, the following
\fIflags\fR
are supported:
.RS 6n
.TP 21n
\fRZIP_FL_ENC_RAW\fR
Return the unmodified archive comment as it is in the ZIP archive.
.TP 21n
\fRZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the archive comment in the ZIP archive and convert it
to UTF-8, if necessary.
(Only CP-437 and UTF-8 are recognized.)
.TP 21n
\fRZIP_FL_ENC_STRICT\fR
Follow the ZIP specification for file names and extend it to the
archive comment, thus also expecting it in CP-437 encoding.
Convert it to UTF-8.
.RE
\fINote\fR:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the comment is returned,
or
\fRNULL\fR
if there is no comment.
.SH "SEE ALSO"
libzip(3),
zip_file_get_comment(3)
.SH "HISTORY"
\fBzip_get_archive_comment\fR()
was added in libzip 0.7.
In libzip 0.11 the type of
\fIflags\fR
was changed from
\fIint\fR
to
\fIzip_flags_t\fR.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
