/*
 * Copyright 1993-2022 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef __cuda_etbl_tools_cuda_api_meta_h__
#define __cuda_etbl_tools_cuda_api_meta_h__

// CU_TOOLS_FOR_EACH_CUDA_API_FUNC allows you to generate code to do an action for
// every function in the CUDA API, or every function included in the current build.
//
// "ACTION" is macro function to apply to the metadata for all CUDA API functions.
// The ACTION must take four parameters:
//     - An "area" which is just a #define for specifying inclusion in the results
//       of SupportedCallbacksInDomain().  For example, if you specify an area "foo"
//       for a set of functions, you must #define SUPPORT_FOR_foo TRUE on platforms
//       that support these functions, and #define SUPPORT_FOR_foo FALSE on platforms
//       that do not support them.  If a function is ever removed, specify REMOVED
//       for its area.
//     - A callback id, or "cbid", which uniquely identifies this API function.
//       These are permanent, so do not change existing functions' cbids, or you
//       will break old tools.  There is some compile-time checking for mistakes
//       in place, but it isn't foolproof.  Please verify these have not changed
//       before each release.
//     - The name of the API function.
//     - A placeholder which should be 0 for now, but may be used to provide
//       extra metadata in future versions.
//
// Add new functions only to the end of this list, and maintain the incrementing
// sequence of cbids.  You will get a compile error if you skip or reorder cbids.
//
#define CU_TOOLS_FOR_EACH_CUDA_API_FUNC( ACTION )                                        \
    ACTION( cuda,          1,   cuInit,                                        0)        \
    ACTION( cuda,          2,   cuDriverGetVersion,                            0)        \
    ACTION( cuda,          3,   cuDeviceGet,                                   0)        \
    ACTION( cuda,          4,   cuDeviceGetCount,                              0)        \
    ACTION( cuda,          5,   cuDeviceGetName,                               0)        \
    ACTION( cuda,          6,   cuDeviceComputeCapability,                     0)        \
    ACTION( cuda,          7,   cuDeviceTotalMem,                              0)        \
    ACTION( cuda,          8,   cuDeviceGetProperties,                         0)        \
    ACTION( cuda,          9,   cuDeviceGetAttribute,                          0)        \
    ACTION( cuda,         10,   cuCtxCreate,                                   0)        \
    ACTION( cuda,         11,   cuCtxDestroy,                                  0)        \
    ACTION( cuda,         12,   cuCtxAttach,                                   0)        \
    ACTION( cuda,         13,   cuCtxDetach,                                   0)        \
    ACTION( cuda,         14,   cuCtxPushCurrent,                              0)        \
    ACTION( cuda,         15,   cuCtxPopCurrent,                               0)        \
    ACTION( cuda,         16,   cuCtxGetDevice,                                0)        \
    ACTION( cuda,         17,   cuCtxSynchronize,                              0)        \
    ACTION( cuda,         18,   cuModuleLoad,                                  0)        \
    ACTION( cuda,         19,   cuModuleLoadData,                              0)        \
    ACTION( cuda,         20,   cuModuleLoadDataEx,                            0)        \
    ACTION( cuda,         21,   cuModuleLoadFatBinary,                         0)        \
    ACTION( cuda,         22,   cuModuleUnload,                                0)        \
    ACTION( cuda,         23,   cuModuleGetFunction,                           0)        \
    ACTION( cuda,         24,   cuModuleGetGlobal,                             0)        \
    ACTION( cuda,         25,   cu64ModuleGetGlobal,                           0)        \
    ACTION( cuda,         26,   cuModuleGetTexRef,                             0)        \
    ACTION( cuda,         27,   cuMemGetInfo,                                  0)        \
    ACTION( cuda,         28,   cu64MemGetInfo,                                0)        \
    ACTION( cuda,         29,   cuMemAlloc,                                    0)        \
    ACTION( cuda,         30,   cu64MemAlloc,                                  0)        \
    ACTION( cuda,         31,   cuMemAllocPitch,                               0)        \
    ACTION( cuda,         32,   cu64MemAllocPitch,                             0)        \
    ACTION( cuda,         33,   cuMemFree,                                     0)        \
    ACTION( cuda,         34,   cu64MemFree,                                   0)        \
    ACTION( cuda,         35,   cuMemGetAddressRange,                          0)        \
    ACTION( cuda,         36,   cu64MemGetAddressRange,                        0)        \
    ACTION( cuda,         37,   cuMemAllocHost,                                0)        \
    ACTION( cuda,         38,   cuMemFreeHost,                                 0)        \
    ACTION( cuda,         39,   cuMemHostAlloc,                                0)        \
    ACTION( cuda,         40,   cuMemHostGetDevicePointer,                     0)        \
    ACTION( cuda,         41,   cu64MemHostGetDevicePointer,                   0)        \
    ACTION( cuda,         42,   cuMemHostGetFlags,                             0)        \
    ACTION( cuda,         43,   cuMemcpyHtoD,                                  0)        \
    ACTION( cuda,         44,   cu64MemcpyHtoD,                                0)        \
    ACTION( cuda,         45,   cuMemcpyDtoH,                                  0)        \
    ACTION( cuda,         46,   cu64MemcpyDtoH,                                0)        \
    ACTION( cuda,         47,   cuMemcpyDtoD,                                  0)        \
    ACTION( cuda,         48,   cu64MemcpyDtoD,                                0)        \
    ACTION( cuda,         49,   cuMemcpyDtoA,                                  0)        \
    ACTION( cuda,         50,   cu64MemcpyDtoA,                                0)        \
    ACTION( cuda,         51,   cuMemcpyAtoD,                                  0)        \
    ACTION( cuda,         52,   cu64MemcpyAtoD,                                0)        \
    ACTION( cuda,         53,   cuMemcpyHtoA,                                  0)        \
    ACTION( cuda,         54,   cuMemcpyAtoH,                                  0)        \
    ACTION( cuda,         55,   cuMemcpyAtoA,                                  0)        \
    ACTION( cuda,         56,   cuMemcpy2D,                                    0)        \
    ACTION( cuda,         57,   cuMemcpy2DUnaligned,                           0)        \
    ACTION( cuda,         58,   cuMemcpy3D,                                    0)        \
    ACTION( cuda,         59,   cu64Memcpy3D,                                  0)        \
    ACTION( cuda,         60,   cuMemcpyHtoDAsync,                             0)        \
    ACTION( cuda,         61,   cu64MemcpyHtoDAsync,                           0)        \
    ACTION( cuda,         62,   cuMemcpyDtoHAsync,                             0)        \
    ACTION( cuda,         63,   cu64MemcpyDtoHAsync,                           0)        \
    ACTION( cuda,         64,   cuMemcpyDtoDAsync,                             0)        \
    ACTION( cuda,         65,   cu64MemcpyDtoDAsync,                           0)        \
    ACTION( cuda,         66,   cuMemcpyHtoAAsync,                             0)        \
    ACTION( cuda,         67,   cuMemcpyAtoHAsync,                             0)        \
    ACTION( cuda,         68,   cuMemcpy2DAsync,                               0)        \
    ACTION( cuda,         69,   cuMemcpy3DAsync,                               0)        \
    ACTION( cuda,         70,   cu64Memcpy3DAsync,                             0)        \
    ACTION( cuda,         71,   cuMemsetD8,                                    0)        \
    ACTION( cuda,         72,   cu64MemsetD8,                                  0)        \
    ACTION( cuda,         73,   cuMemsetD16,                                   0)        \
    ACTION( cuda,         74,   cu64MemsetD16,                                 0)        \
    ACTION( cuda,         75,   cuMemsetD32,                                   0)        \
    ACTION( cuda,         76,   cu64MemsetD32,                                 0)        \
    ACTION( cuda,         77,   cuMemsetD2D8,                                  0)        \
    ACTION( cuda,         78,   cu64MemsetD2D8,                                0)        \
    ACTION( cuda,         79,   cuMemsetD2D16,                                 0)        \
    ACTION( cuda,         80,   cu64MemsetD2D16,                               0)        \
    ACTION( cuda,         81,   cuMemsetD2D32,                                 0)        \
    ACTION( cuda,         82,   cu64MemsetD2D32,                               0)        \
    ACTION( cuda,         83,   cuFuncSetBlockShape,                           0)        \
    ACTION( cuda,         84,   cuFuncSetSharedSize,                           0)        \
    ACTION( cuda,         85,   cuFuncGetAttribute,                            0)        \
    ACTION( cuda,         86,   cuFuncSetCacheConfig,                          0)        \
    ACTION( cuda,         87,   cuArrayCreate,                                 0)        \
    ACTION( cuda,         88,   cuArrayGetDescriptor,                          0)        \
    ACTION( cuda,         89,   cuArrayDestroy,                                0)        \
    ACTION( cuda,         90,   cuArray3DCreate,                               0)        \
    ACTION( cuda,         91,   cuArray3DGetDescriptor,                        0)        \
    ACTION( cuda,         92,   cuTexRefCreate,                                0)        \
    ACTION( cuda,         93,   cuTexRefDestroy,                               0)        \
    ACTION( cuda,         94,   cuTexRefSetArray,                              0)        \
    ACTION( cuda,         95,   cuTexRefSetAddress,                            0)        \
    ACTION( cuda,         96,   cu64TexRefSetAddress,                          0)        \
    ACTION( cuda,         97,   cuTexRefSetAddress2D,                          0)        \
    ACTION( cuda,         98,   cu64TexRefSetAddress2D,                        0)        \
    ACTION( cuda,         99,   cuTexRefSetFormat,                             0)        \
    ACTION( cuda,        100,   cuTexRefSetAddressMode,                        0)        \
    ACTION( cuda,        101,   cuTexRefSetFilterMode,                         0)        \
    ACTION( cuda,        102,   cuTexRefSetFlags,                              0)        \
    ACTION( cuda,        103,   cuTexRefGetAddress,                            0)        \
    ACTION( cuda,        104,   cu64TexRefGetAddress,                          0)        \
    ACTION( cuda,        105,   cuTexRefGetArray,                              0)        \
    ACTION( cuda,        106,   cuTexRefGetAddressMode,                        0)        \
    ACTION( cuda,        107,   cuTexRefGetFilterMode,                         0)        \
    ACTION( cuda,        108,   cuTexRefGetFormat,                             0)        \
    ACTION( cuda,        109,   cuTexRefGetFlags,                              0)        \
    ACTION( cuda,        110,   cuParamSetSize,                                0)        \
    ACTION( cuda,        111,   cuParamSeti,                                   0)        \
    ACTION( cuda,        112,   cuParamSetf,                                   0)        \
    ACTION( cuda,        113,   cuParamSetv,                                   0)        \
    ACTION( cuda,        114,   cuParamSetTexRef,                              0)        \
    ACTION( cuda,        115,   cuLaunch,                                      0)        \
    ACTION( cuda,        116,   cuLaunchGrid,                                  0)        \
    ACTION( cuda,        117,   cuLaunchGridAsync,                             0)        \
    ACTION( cuda,        118,   cuEventCreate,                                 0)        \
    ACTION( cuda,        119,   cuEventRecord,                                 0)        \
    ACTION( cuda,        120,   cuEventQuery,                                  0)        \
    ACTION( cuda,        121,   cuEventSynchronize,                            0)        \
    ACTION( cuda,        122,   cuEventDestroy,                                0)        \
    ACTION( cuda,        123,   cuEventElapsedTime,                            0)        \
    ACTION( cuda,        124,   cuStreamCreate,                                0)        \
    ACTION( cuda,        125,   cuStreamQuery,                                 0)        \
    ACTION( cuda,        126,   cuStreamSynchronize,                           0)        \
    ACTION( cuda,        127,   cuStreamDestroy,                               0)        \
    ACTION( cuda,        128,   cuGraphicsUnregisterResource,                  0)        \
    ACTION( cuda,        129,   cuGraphicsSubResourceGetMappedArray,           0)        \
    ACTION( cuda,        130,   cuGraphicsResourceGetMappedPointer,            0)        \
    ACTION( cuda,        131,   cu64GraphicsResourceGetMappedPointer,          0)        \
    ACTION( cuda,        132,   cuGraphicsResourceSetMapFlags,                 0)        \
    ACTION( cuda,        133,   cuGraphicsMapResources,                        0)        \
    ACTION( cuda,        134,   cuGraphicsUnmapResources,                      0)        \
    ACTION( cuda,        135,   cuGetExportTable,                              0)        \
    ACTION( cuda,        136,   cuCtxSetLimit,                                 0)        \
    ACTION( cuda,        137,   cuCtxGetLimit,                                 0)        \
    ACTION( cudaD3D10,   138,   cuD3D10GetDevice,                              0)        \
    ACTION( cudaD3D10,   139,   cuD3D10CtxCreate,                              0)        \
    ACTION( cudaD3D10,   140,   cuGraphicsD3D10RegisterResource,               0)        \
    ACTION( cudaD3D10,   141,   cuD3D10RegisterResource,                       0)        \
    ACTION( cudaD3D10,   142,   cuD3D10UnregisterResource,                     0)        \
    ACTION( cudaD3D10,   143,   cuD3D10MapResources,                           0)        \
    ACTION( cudaD3D10,   144,   cuD3D10UnmapResources,                         0)        \
    ACTION( cudaD3D10,   145,   cuD3D10ResourceSetMapFlags,                    0)        \
    ACTION( cudaD3D10,   146,   cuD3D10ResourceGetMappedArray,                 0)        \
    ACTION( cudaD3D10,   147,   cuD3D10ResourceGetMappedPointer,               0)        \
    ACTION( cudaD3D10,   148,   cuD3D10ResourceGetMappedSize,                  0)        \
    ACTION( cudaD3D10,   149,   cuD3D10ResourceGetMappedPitch,                 0)        \
    ACTION( cudaD3D10,   150,   cuD3D10ResourceGetSurfaceDimensions,           0)        \
    ACTION( cudaD3D11,   151,   cuD3D11GetDevice,                              0)        \
    ACTION( cudaD3D11,   152,   cuD3D11CtxCreate,                              0)        \
    ACTION( cudaD3D11,   153,   cuGraphicsD3D11RegisterResource,               0)        \
    ACTION( cudaD3D9,    154,   cuD3D9GetDevice,                               0)        \
    ACTION( cudaD3D9,    155,   cuD3D9CtxCreate,                               0)        \
    ACTION( cudaD3D9,    156,   cuGraphicsD3D9RegisterResource,                0)        \
    ACTION( cudaD3D9,    157,   cuD3D9GetDirect3DDevice,                       0)        \
    ACTION( cudaD3D9,    158,   cuD3D9RegisterResource,                        0)        \
    ACTION( cudaD3D9,    159,   cuD3D9UnregisterResource,                      0)        \
    ACTION( cudaD3D9,    160,   cuD3D9MapResources,                            0)        \
    ACTION( cudaD3D9,    161,   cuD3D9UnmapResources,                          0)        \
    ACTION( cudaD3D9,    162,   cuD3D9ResourceSetMapFlags,                     0)        \
    ACTION( cudaD3D9,    163,   cuD3D9ResourceGetSurfaceDimensions,            0)        \
    ACTION( cudaD3D9,    164,   cuD3D9ResourceGetMappedArray,                  0)        \
    ACTION( cudaD3D9,    165,   cuD3D9ResourceGetMappedPointer,                0)        \
    ACTION( cudaD3D9,    166,   cuD3D9ResourceGetMappedSize,                   0)        \
    ACTION( cudaD3D9,    167,   cuD3D9ResourceGetMappedPitch,                  0)        \
    ACTION( cudaD3D9,    168,   cuD3D9Begin,                                   0)        \
    ACTION( cudaD3D9,    169,   cuD3D9End,                                     0)        \
    ACTION( cudaD3D9,    170,   cuD3D9RegisterVertexBuffer,                    0)        \
    ACTION( cudaD3D9,    171,   cuD3D9MapVertexBuffer,                         0)        \
    ACTION( cudaD3D9,    172,   cuD3D9UnmapVertexBuffer,                       0)        \
    ACTION( cudaD3D9,    173,   cuD3D9UnregisterVertexBuffer,                  0)        \
    ACTION( cudaGL,      174,   cuGLCtxCreate,                                 0)        \
    ACTION( cudaGL,      175,   cuGraphicsGLRegisterBuffer,                    0)        \
    ACTION( cudaGL,      176,   cuGraphicsGLRegisterImage,                     0)        \
    ACTION( cudaWGL,     177,   cuWGLGetDevice,                                0)        \
    ACTION( cudaGL,      178,   cuGLInit,                                      0)        \
    ACTION( cudaGL,      179,   cuGLRegisterBufferObject,                      0)        \
    ACTION( cudaGL,      180,   cuGLMapBufferObject,                           0)        \
    ACTION( cudaGL,      181,   cuGLUnmapBufferObject,                         0)        \
    ACTION( cudaGL,      182,   cuGLUnregisterBufferObject,                    0)        \
    ACTION( cudaGL,      183,   cuGLSetBufferObjectMapFlags,                   0)        \
    ACTION( cudaGL,      184,   cuGLMapBufferObjectAsync,                      0)        \
    ACTION( cudaGL,      185,   cuGLUnmapBufferObjectAsync,                    0)        \
    ACTION( cudaVDPAU,   186,   cuVDPAUGetDevice,                              0)        \
    ACTION( cudaVDPAU,   187,   cuVDPAUCtxCreate,                              0)        \
    ACTION( cudaVDPAU,   188,   cuGraphicsVDPAURegisterVideoSurface,           0)        \
    ACTION( cudaVDPAU,   189,   cuGraphicsVDPAURegisterOutputSurface,          0)        \
    ACTION( cuda,        190,   cuModuleGetSurfRef,                            0)        \
    ACTION( cuda,        191,   cuSurfRefCreate,                               0)        \
    ACTION( cuda,        192,   cuSurfRefDestroy,                              0)        \
    ACTION( cuda,        193,   cuSurfRefSetFormat,                            0)        \
    ACTION( cuda,        194,   cuSurfRefSetArray,                             0)        \
    ACTION( cuda,        195,   cuSurfRefGetFormat,                            0)        \
    ACTION( cuda,        196,   cuSurfRefGetArray,                             0)        \
    ACTION( cuda,        197,   cu64DeviceTotalMem,                            0)        \
    ACTION( cudaD3D10,   198,   cu64D3D10ResourceGetMappedPointer,             0)        \
    ACTION( cudaD3D10,   199,   cu64D3D10ResourceGetMappedSize,                0)        \
    ACTION( cudaD3D10,   200,   cu64D3D10ResourceGetMappedPitch,               0)        \
    ACTION( cudaD3D10,   201,   cu64D3D10ResourceGetSurfaceDimensions,         0)        \
    ACTION( cudaD3D9,    202,   cu64D3D9ResourceGetSurfaceDimensions,          0)        \
    ACTION( cudaD3D9,    203,   cu64D3D9ResourceGetMappedPointer,              0)        \
    ACTION( cudaD3D9,    204,   cu64D3D9ResourceGetMappedSize,                 0)        \
    ACTION( cudaD3D9,    205,   cu64D3D9ResourceGetMappedPitch,                0)        \
    ACTION( cudaD3D9,    206,   cu64D3D9MapVertexBuffer,                       0)        \
    ACTION( cudaGL,      207,   cu64GLMapBufferObject,                         0)        \
    ACTION( cudaGL,      208,   cu64GLMapBufferObjectAsync,                    0)        \
    ACTION( cudaD3D11,   209,   cuD3D11GetDevices,                             0)        \
    ACTION( cudaD3D11,   210,   cuD3D11CtxCreateOnDevice,                      0)        \
    ACTION( cudaD3D10,   211,   cuD3D10GetDevices,                             0)        \
    ACTION( cudaD3D10,   212,   cuD3D10CtxCreateOnDevice,                      0)        \
    ACTION( cudaD3D9,    213,   cuD3D9GetDevices,                              0)        \
    ACTION( cudaD3D9,    214,   cuD3D9CtxCreateOnDevice,                       0)        \
    ACTION( cuda,        215,   cu64MemHostAlloc,                              0)        \
    ACTION( cuda,        216,   cuMemsetD8Async,                               0)        \
    ACTION( cuda,        217,   cu64MemsetD8Async,                             0)        \
    ACTION( cuda,        218,   cuMemsetD16Async,                              0)        \
    ACTION( cuda,        219,   cu64MemsetD16Async,                            0)        \
    ACTION( cuda,        220,   cuMemsetD32Async,                              0)        \
    ACTION( cuda,        221,   cu64MemsetD32Async,                            0)        \
    ACTION( cuda,        222,   cuMemsetD2D8Async,                             0)        \
    ACTION( cuda,        223,   cu64MemsetD2D8Async,                           0)        \
    ACTION( cuda,        224,   cuMemsetD2D16Async,                            0)        \
    ACTION( cuda,        225,   cu64MemsetD2D16Async,                          0)        \
    ACTION( cuda,        226,   cuMemsetD2D32Async,                            0)        \
    ACTION( cuda,        227,   cu64MemsetD2D32Async,                          0)        \
    ACTION( cuda,        228,   cu64ArrayCreate,                               0)        \
    ACTION( cuda,        229,   cu64ArrayGetDescriptor,                        0)        \
    ACTION( cuda,        230,   cu64Array3DCreate,                             0)        \
    ACTION( cuda,        231,   cu64Array3DGetDescriptor,                      0)        \
    ACTION( cuda,        232,   cu64Memcpy2D,                                  0)        \
    ACTION( cuda,        233,   cu64Memcpy2DUnaligned,                         0)        \
    ACTION( cuda,        234,   cu64Memcpy2DAsync,                             0)        \
    ACTION( cuda,        235,   cuCtxCreate_v2,                                0)        \
    ACTION( cudaD3D10,   236,   cuD3D10CtxCreate_v2,                           0)        \
    ACTION( cudaD3D11,   237,   cuD3D11CtxCreate_v2,                           0)        \
    ACTION( cudaD3D9,    238,   cuD3D9CtxCreate_v2,                            0)        \
    ACTION( cudaGL,      239,   cuGLCtxCreate_v2,                              0)        \
    ACTION( cudaVDPAU,   240,   cuVDPAUCtxCreate_v2,                           0)        \
    ACTION( cuda,        241,   cuModuleGetGlobal_v2,                          0)        \
    ACTION( cuda,        242,   cuMemGetInfo_v2,                               0)        \
    ACTION( cuda,        243,   cuMemAlloc_v2,                                 0)        \
    ACTION( cuda,        244,   cuMemAllocPitch_v2,                            0)        \
    ACTION( cuda,        245,   cuMemFree_v2,                                  0)        \
    ACTION( cuda,        246,   cuMemGetAddressRange_v2,                       0)        \
    ACTION( cuda,        247,   cuMemHostGetDevicePointer_v2,                  0)        \
    ACTION( cuda,        248,   cuMemcpy_v2,                                   0)        \
    ACTION( cuda,        249,   cuMemsetD8_v2,                                 0)        \
    ACTION( cuda,        250,   cuMemsetD16_v2,                                0)        \
    ACTION( cuda,        251,   cuMemsetD32_v2,                                0)        \
    ACTION( cuda,        252,   cuMemsetD2D8_v2,                               0)        \
    ACTION( cuda,        253,   cuMemsetD2D16_v2,                              0)        \
    ACTION( cuda,        254,   cuMemsetD2D32_v2,                              0)        \
    ACTION( cuda,        255,   cuTexRefSetAddress_v2,                         0)        \
    ACTION( cuda,        256,   cuTexRefSetAddress2D_v2,                       0)        \
    ACTION( cuda,        257,   cuTexRefGetAddress_v2,                         0)        \
    ACTION( cuda,        258,   cuGraphicsResourceGetMappedPointer_v2,         0)        \
    ACTION( cuda,        259,   cuDeviceTotalMem_v2,                           0)        \
    ACTION( cudaD3D10,   260,   cuD3D10ResourceGetMappedPointer_v2,            0)        \
    ACTION( cudaD3D10,   261,   cuD3D10ResourceGetMappedSize_v2,               0)        \
    ACTION( cudaD3D10,   262,   cuD3D10ResourceGetMappedPitch_v2,              0)        \
    ACTION( cudaD3D10,   263,   cuD3D10ResourceGetSurfaceDimensions_v2,        0)        \
    ACTION( cudaD3D9,    264,   cuD3D9ResourceGetSurfaceDimensions_v2,         0)        \
    ACTION( cudaD3D9,    265,   cuD3D9ResourceGetMappedPointer_v2,             0)        \
    ACTION( cudaD3D9,    266,   cuD3D9ResourceGetMappedSize_v2,                0)        \
    ACTION( cudaD3D9,    267,   cuD3D9ResourceGetMappedPitch_v2,               0)        \
    ACTION( cudaD3D9,    268,   cuD3D9MapVertexBuffer_v2,                      0)        \
    ACTION( cudaGL,      269,   cuGLMapBufferObject_v2,                        0)        \
    ACTION( cudaGL,      270,   cuGLMapBufferObjectAsync_v2,                   0)        \
    ACTION( cuda,        271,   cuMemHostAlloc_v2,                             0)        \
    ACTION( cuda,        272,   cuArrayCreate_v2,                              0)        \
    ACTION( cuda,        273,   cuArrayGetDescriptor_v2,                       0)        \
    ACTION( cuda,        274,   cuArray3DCreate_v2,                            0)        \
    ACTION( cuda,        275,   cuArray3DGetDescriptor_v2,                     0)        \
    ACTION( cuda,        276,   cuMemcpyHtoD_v2,                               0)        \
    ACTION( cuda,        277,   cuMemcpyHtoDAsync_v2,                          0)        \
    ACTION( cuda,        278,   cuMemcpyDtoH_v2,                               0)        \
    ACTION( cuda,        279,   cuMemcpyDtoHAsync_v2,                          0)        \
    ACTION( cuda,        280,   cuMemcpyDtoD_v2,                               0)        \
    ACTION( cuda,        281,   cuMemcpyDtoDAsync_v2,                          0)        \
    ACTION( cuda,        282,   cuMemcpyAtoH_v2,                               0)        \
    ACTION( cuda,        283,   cuMemcpyAtoHAsync_v2,                          0)        \
    ACTION( cuda,        284,   cuMemcpyAtoD_v2,                               0)        \
    ACTION( cuda,        285,   cuMemcpyDtoA_v2,                               0)        \
    ACTION( cuda,        286,   cuMemcpyAtoA_v2,                               0)        \
    ACTION( cuda,        287,   cuMemcpy2D_v2,                                 0)        \
    ACTION( cuda,        288,   cuMemcpy2DUnaligned_v2,                        0)        \
    ACTION( cuda,        289,   cuMemcpy2DAsync_v2,                            0)        \
    ACTION( cuda,        290,   cuMemcpy3D_v2,                                 0)        \
    ACTION( cuda,        291,   cuMemcpy3DAsync_v2,                            0)        \
    ACTION( cuda,        292,   cuMemcpyHtoA_v2,                               0)        \
    ACTION( cuda,        293,   cuMemcpyHtoAAsync_v2,                          0)        \
    ACTION( cuda,        294,   cuMemAllocHost_v2,                             0)        \
    ACTION( cuda,        295,   cuStreamWaitEvent,                             0)        \
    ACTION( cuda,        296,   cuCtxGetApiVersion,                            0)        \
    ACTION( cudaD3D10,   297,   cuD3D10GetDirect3DDevice,                      0)        \
    ACTION( cudaD3D11,   298,   cuD3D11GetDirect3DDevice,                      0)        \
    ACTION( cuda,        299,   cuCtxGetCacheConfig,                           0)        \
    ACTION( cuda,        300,   cuCtxSetCacheConfig,                           0)        \
    ACTION( cuda,        301,   cuMemHostRegister,                             0)        \
    ACTION( cuda,        302,   cuMemHostUnregister,                           0)        \
    ACTION( cuda,        303,   cuCtxSetCurrent,                               0)        \
    ACTION( cuda,        304,   cuCtxGetCurrent,                               0)        \
    ACTION( cuda,        305,   cuMemcpy,                                      0)        \
    ACTION( cuda,        306,   cuMemcpyAsync,                                 0)        \
    ACTION( cuda,        307,   cuLaunchKernel,                                0)        \
    ACTION( cuda,        308,   cuProfilerStart,                               0)        \
    ACTION( cuda,        309,   cuProfilerStop,                                0)        \
    ACTION( cuda,        310,   cuPointerGetAttribute,                         0)        \
    ACTION( cuda,        311,   cuProfilerInitialize,                          0)        \
    ACTION( cuda,        312,   cuDeviceCanAccessPeer,                         0)        \
    ACTION( cuda,        313,   cuCtxEnablePeerAccess,                         0)        \
    ACTION( cuda,        314,   cuCtxDisablePeerAccess,                        0)        \
    ACTION( cuda,        315,   cuMemPeerRegister,                             0)        \
    ACTION( cuda,        316,   cuMemPeerUnregister,                           0)        \
    ACTION( cuda,        317,   cuMemPeerGetDevicePointer,                     0)        \
    ACTION( cuda,        318,   cuMemcpyPeer,                                  0)        \
    ACTION( cuda,        319,   cuMemcpyPeerAsync,                             0)        \
    ACTION( cuda,        320,   cuMemcpy3DPeer,                                0)        \
    ACTION( cuda,        321,   cuMemcpy3DPeerAsync,                           0)        \
    ACTION( cuda,        322,   cuCtxDestroy_v2,                               0)        \
    ACTION( cuda,        323,   cuCtxPushCurrent_v2,                           0)        \
    ACTION( cuda,        324,   cuCtxPopCurrent_v2,                            0)        \
    ACTION( cuda,        325,   cuEventDestroy_v2,                             0)        \
    ACTION( cuda,        326,   cuStreamDestroy_v2,                            0)        \
    ACTION( cuda,        327,   cuTexRefSetAddress2D_v3,                       0)        \
    ACTION( cuda,        328,   cuIpcGetMemHandle,                             0)        \
    ACTION( cuda,        329,   cuIpcOpenMemHandle,                            0)        \
    ACTION( cuda,        330,   cuIpcCloseMemHandle,                           0)        \
    ACTION( cuda,        331,   cuDeviceGetByPCIBusId,                         0)        \
    ACTION( cuda,        332,   cuDeviceGetPCIBusId,                           0)        \
    ACTION( cudaGL,      333,   cuGLGetDevices,                                0)        \
    ACTION( cuda,        334,   cuIpcGetEventHandle,                           0)        \
    ACTION( cuda,        335,   cuIpcOpenEventHandle,                          0)        \
    ACTION( cuda,        336,   cuCtxSetSharedMemConfig,                       0)        \
    ACTION( cuda,        337,   cuCtxGetSharedMemConfig,                       0)        \
    ACTION( cuda,        338,   cuFuncSetSharedMemConfig,                      0)        \
    ACTION( cuda,        339,   cuTexObjectCreate,                             0)        \
    ACTION( cuda,        340,   cuTexObjectDestroy,                            0)        \
    ACTION( cuda,        341,   cuTexObjectGetResourceDesc,                    0)        \
    ACTION( cuda,        342,   cuTexObjectGetTextureDesc,                     0)        \
    ACTION( cuda,        343,   cuSurfObjectCreate,                            0)        \
    ACTION( cuda,        344,   cuSurfObjectDestroy,                           0)        \
    ACTION( cuda,        345,   cuSurfObjectGetResourceDesc,                   0)        \
    ACTION( cuda,        346,   cuStreamAddCallback,                           0)        \
    ACTION( cuda,        347,   cuMipmappedArrayCreate,                        0)        \
    ACTION( cuda,        348,   cuMipmappedArrayGetLevel,                      0)        \
    ACTION( cuda,        349,   cuMipmappedArrayDestroy,                       0)        \
    ACTION( cuda,        350,   cuTexRefSetMipmappedArray,                     0)        \
    ACTION( cuda,        351,   cuTexRefSetMipmapFilterMode,                   0)        \
    ACTION( cuda,        352,   cuTexRefSetMipmapLevelBias,                    0)        \
    ACTION( cuda,        353,   cuTexRefSetMipmapLevelClamp,                   0)        \
    ACTION( cuda,        354,   cuTexRefSetMaxAnisotropy,                      0)        \
    ACTION( cuda,        355,   cuTexRefGetMipmappedArray,                     0)        \
    ACTION( cuda,        356,   cuTexRefGetMipmapFilterMode,                   0)        \
    ACTION( cuda,        357,   cuTexRefGetMipmapLevelBias,                    0)        \
    ACTION( cuda,        358,   cuTexRefGetMipmapLevelClamp,                   0)        \
    ACTION( cuda,        359,   cuTexRefGetMaxAnisotropy,                      0)        \
    ACTION( cuda,        360,   cuGraphicsResourceGetMappedMipmappedArray,     0)        \
    ACTION( cuda,        361,   cuTexObjectGetResourceViewDesc,                0)        \
    ACTION( cuda,        362,   cuLinkCreate,                                  0)        \
    ACTION( cuda,        363,   cuLinkAddData,                                 0)        \
    ACTION( cuda,        364,   cuLinkAddFile,                                 0)        \
    ACTION( cuda,        365,   cuLinkComplete,                                0)        \
    ACTION( cuda,        366,   cuLinkDestroy,                                 0)        \
    ACTION( cuda,        367,   cuStreamCreateWithPriority,                    0)        \
    ACTION( cuda,        368,   cuStreamGetPriority,                           0)        \
    ACTION( cuda,        369,   cuStreamGetFlags,                              0)        \
    ACTION( cuda,        370,   cuCtxGetStreamPriorityRange,                   0)        \
    ACTION( cuda,        371,   cuMemAllocManaged,                             0)        \
    ACTION( cuda,        372,   cuGetErrorString,                              0)        \
    ACTION( cuda,        373,   cuGetErrorName,                                0)        \
    ACTION( cuda,        374,   cuOccupancyMaxActiveBlocksPerMultiprocessor,   0)        \
    ACTION( cuda,        375,   cuCompilePtx,                                  0)        \
    ACTION( cuda,        376,   cuBinaryFree,                                  0)        \
    ACTION( cuda,        377,   cuStreamAttachMemAsync,                        0)        \
    ACTION( cuda,        378,   cuPointerSetAttribute,                         0)        \
    ACTION( cuda,        379,   cuMemHostRegister_v2,                          0)        \
    ACTION( cuda,        380,   cuGraphicsResourceSetMapFlags_v2,              0)        \
    ACTION( cuda,        381,   cuLinkCreate_v2,                               0)        \
    ACTION( cuda,        382,   cuLinkAddData_v2,                              0)        \
    ACTION( cuda,        383,   cuLinkAddFile_v2,                              0)        \
    ACTION( cuda,        384,   cuOccupancyMaxPotentialBlockSize,              0)        \
    ACTION( cudaGL,      385,   cuGLGetDevices_v2,                             0)        \
    ACTION( cuda,        386,   cuDevicePrimaryCtxRetain,                      0)        \
    ACTION( cuda,        387,   cuDevicePrimaryCtxRelease,                     0)        \
    ACTION( cuda,        388,   cuDevicePrimaryCtxSetFlags,                    0)        \
    ACTION( cuda,        389,   cuDevicePrimaryCtxReset,                       0)        \
    ACTION( cudaEGL,     390,   cuGraphicsEGLRegisterImage,                    0)        \
    ACTION( cuda,        391,   cuCtxGetFlags,                                 0)        \
    ACTION( cuda,        392,   cuDevicePrimaryCtxGetState,                    0)        \
    ACTION( cudaEGL,     393,   cuEGLStreamConsumerConnect,                    0)        \
    ACTION( cudaEGL,     394,   cuEGLStreamConsumerDisconnect,                 0)        \
    ACTION( cudaEGL,     395,   cuEGLStreamConsumerAcquireFrame,               0)        \
    ACTION( cudaEGL,     396,   cuEGLStreamConsumerReleaseFrame,               0)        \
    ACTION( cuda,        397,   cuMemcpyHtoD_v2_ptds,                          0)        \
    ACTION( cuda,        398,   cuMemcpyDtoH_v2_ptds,                          0)        \
    ACTION( cuda,        399,   cuMemcpyDtoD_v2_ptds,                          0)        \
    ACTION( cuda,        400,   cuMemcpyDtoA_v2_ptds,                          0)        \
    ACTION( cuda,        401,   cuMemcpyAtoD_v2_ptds,                          0)        \
    ACTION( cuda,        402,   cuMemcpyHtoA_v2_ptds,                          0)        \
    ACTION( cuda,        403,   cuMemcpyAtoH_v2_ptds,                          0)        \
    ACTION( cuda,        404,   cuMemcpyAtoA_v2_ptds,                          0)        \
    ACTION( cuda,        405,   cuMemcpy2D_v2_ptds,                            0)        \
    ACTION( cuda,        406,   cuMemcpy2DUnaligned_v2_ptds,                   0)        \
    ACTION( cuda,        407,   cuMemcpy3D_v2_ptds,                            0)        \
    ACTION( cuda,        408,   cuMemcpy_ptds,                                 0)        \
    ACTION( cuda,        409,   cuMemcpyPeer_ptds,                             0)        \
    ACTION( cuda,        410,   cuMemcpy3DPeer_ptds,                           0)        \
    ACTION( cuda,        411,   cuMemsetD8_v2_ptds,                            0)        \
    ACTION( cuda,        412,   cuMemsetD16_v2_ptds,                           0)        \
    ACTION( cuda,        413,   cuMemsetD32_v2_ptds,                           0)        \
    ACTION( cuda,        414,   cuMemsetD2D8_v2_ptds,                          0)        \
    ACTION( cuda,        415,   cuMemsetD2D16_v2_ptds,                         0)        \
    ACTION( cuda,        416,   cuMemsetD2D32_v2_ptds,                         0)        \
    ACTION( cudaGL,      417,   cuGLMapBufferObject_v2_ptds,                   0)        \
    ACTION( cuda,        418,   cuMemcpyAsync_ptsz,                            0)        \
    ACTION( cuda,        419,   cuMemcpyHtoAAsync_v2_ptsz,                     0)        \
    ACTION( cuda,        420,   cuMemcpyAtoHAsync_v2_ptsz,                     0)        \
    ACTION( cuda,        421,   cuMemcpyHtoDAsync_v2_ptsz,                     0)        \
    ACTION( cuda,        422,   cuMemcpyDtoHAsync_v2_ptsz,                     0)        \
    ACTION( cuda,        423,   cuMemcpyDtoDAsync_v2_ptsz,                     0)        \
    ACTION( cuda,        424,   cuMemcpy2DAsync_v2_ptsz,                       0)        \
    ACTION( cuda,        425,   cuMemcpy3DAsync_v2_ptsz,                       0)        \
    ACTION( cuda,        426,   cuMemcpyPeerAsync_ptsz,                        0)        \
    ACTION( cuda,        427,   cuMemcpy3DPeerAsync_ptsz,                      0)        \
    ACTION( cuda,        428,   cuMemsetD8Async_ptsz,                          0)        \
    ACTION( cuda,        429,   cuMemsetD16Async_ptsz,                         0)        \
    ACTION( cuda,        430,   cuMemsetD32Async_ptsz,                         0)        \
    ACTION( cuda,        431,   cuMemsetD2D8Async_ptsz,                        0)        \
    ACTION( cuda,        432,   cuMemsetD2D16Async_ptsz,                       0)        \
    ACTION( cuda,        433,   cuMemsetD2D32Async_ptsz,                       0)        \
    ACTION( cuda,        434,   cuStreamGetPriority_ptsz,                      0)        \
    ACTION( cuda,        435,   cuStreamGetFlags_ptsz,                         0)        \
    ACTION( cuda,        436,   cuStreamWaitEvent_ptsz,                        0)        \
    ACTION( cuda,        437,   cuStreamAddCallback_ptsz,                      0)        \
    ACTION( cuda,        438,   cuStreamAttachMemAsync_ptsz,                   0)        \
    ACTION( cuda,        439,   cuStreamQuery_ptsz,                            0)        \
    ACTION( cuda,        440,   cuStreamSynchronize_ptsz,                      0)        \
    ACTION( cuda,        441,   cuEventRecord_ptsz,                            0)        \
    ACTION( cuda,        442,   cuLaunchKernel_ptsz,                           0)        \
    ACTION( cuda,        443,   cuGraphicsMapResources_ptsz,                   0)        \
    ACTION( cuda,        444,   cuGraphicsUnmapResources_ptsz,                 0)        \
    ACTION( cudaGL,      445,   cuGLMapBufferObjectAsync_v2_ptsz,              0)        \
    ACTION( cudaEGL,     446,   cuEGLStreamProducerConnect,                    0)        \
    ACTION( cudaEGL,     447,   cuEGLStreamProducerDisconnect,                 0)        \
    ACTION( cudaEGL,     448,   cuEGLStreamProducerPresentFrame,               0)        \
    ACTION( cudaEGL,     449,   cuGraphicsResourceGetMappedEglFrame,           0)        \
    ACTION( cuda,        450,   cuPointerGetAttributes,                        0)        \
    ACTION( cuda,        451,   cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, 0) \
    ACTION( cuda,        452,   cuOccupancyMaxPotentialBlockSizeWithFlags,     0)        \
    ACTION( cudaEGL,     453,   cuEGLStreamProducerReturnFrame,                0)        \
    ACTION( cuda,        454,   cuDeviceGetP2PAttribute,                       0)        \
    ACTION( cuda,        455,   cuTexRefSetBorderColor,                        0)        \
    ACTION( cuda,        456,   cuTexRefGetBorderColor,                        0)        \
    ACTION( cuda,        457,   cuMemAdvise,                                   0)        \
    ACTION( cuda,        458,   cuStreamWaitValue32,                           0)        \
    ACTION( cuda,        459,   cuStreamWaitValue32_ptsz,                      0)        \
    ACTION( cuda,        460,   cuStreamWriteValue32,                          0)        \
    ACTION( cuda,        461,   cuStreamWriteValue32_ptsz,                     0)        \
    ACTION( cuda,        462,   cuStreamBatchMemOp,                            0)        \
    ACTION( cuda,        463,   cuStreamBatchMemOp_ptsz,                       0)        \
    ACTION( cudaNVN,     464,   cuNVNbufferGetPointer,                         0)        \
    ACTION( cudaNVN,     465,   cuNVNtextureGetArray,                          0)        \
    ACTION( cudaNN,      466,   cuNNSetAllocator,                              0)        \
    ACTION( cuda,        467,   cuMemPrefetchAsync,                            0)        \
    ACTION( cuda,        468,   cuMemPrefetchAsync_ptsz,                       0)        \
    ACTION( cudaNVN,     469,   cuEventCreateFromNVNSync,                      0)        \
    ACTION( cudaEGL,     470,   cuEGLStreamConsumerConnectWithFlags,           0)        \
    ACTION( cuda,        471,   cuMemRangeGetAttribute,                        0)        \
    ACTION( cuda,        472,   cuMemRangeGetAttributes,                       0)        \
    ACTION( cuda,        473,   cuStreamWaitValue64,                           0)        \
    ACTION( cuda,        474,   cuStreamWaitValue64_ptsz,                      0)        \
    ACTION( cuda,        475,   cuStreamWriteValue64,                          0)        \
    ACTION( cuda,        476,   cuStreamWriteValue64_ptsz,                     0)        \
    ACTION( cuda,        477,   cuLaunchCooperativeKernel,                     0)        \
    ACTION( cuda,        478,   cuLaunchCooperativeKernel_ptsz,                0)        \
    ACTION( cudaEGL,     479,   cuEventCreateFromEGLSync,                      0)        \
    ACTION( cuda,        480,   cuLaunchCooperativeKernelMultiDevice,          0)        \
    ACTION( cuda,        481,   cuFuncSetAttribute,                            0)        \
    ACTION( cuda,        482,   cuDeviceGetUuid,                               0)        \
    ACTION( cuda,        483,   cuStreamGetCtx,                                0)        \
    ACTION( cuda,        484,   cuStreamGetCtx_ptsz,                           0)        \
    ACTION( cuda,        485,   cuImportExternalMemory,                        0)        \
    ACTION( cuda,        486,   cuExternalMemoryGetMappedBuffer,               0)        \
    ACTION( cuda,        487,   cuExternalMemoryGetMappedMipmappedArray,       0)        \
    ACTION( cuda,        488,   cuDestroyExternalMemory,                       0)        \
    ACTION( cuda,        489,   cuImportExternalSemaphore,                     0)        \
    ACTION( cuda,        490,   cuSignalExternalSemaphoresAsync,               0)        \
    ACTION( cuda,        491,   cuSignalExternalSemaphoresAsync_ptsz,          0)        \
    ACTION( cuda,        492,   cuWaitExternalSemaphoresAsync,                 0)        \
    ACTION( cuda,        493,   cuWaitExternalSemaphoresAsync_ptsz,            0)        \
    ACTION( cuda,        494,   cuDestroyExternalSemaphore,                    0)        \
    ACTION( cuda,        495,   cuStreamBeginCapture,                          0)        \
    ACTION( cuda,        496,   cuStreamBeginCapture_ptsz,                     0)        \
    ACTION( cuda,        497,   cuStreamEndCapture,                            0)        \
    ACTION( cuda,        498,   cuStreamEndCapture_ptsz,                       0)        \
    ACTION( cuda,        499,   cuStreamIsCapturing,                           0)        \
    ACTION( cuda,        500,   cuStreamIsCapturing_ptsz,                      0)        \
    ACTION( cuda,        501,   cuGraphCreate,                                 0)        \
    ACTION( cuda,        502,   cuGraphAddKernelNode,                          0)        \
    ACTION( cuda,        503,   cuGraphKernelNodeGetParams,                    0)        \
    ACTION( cuda,        504,   cuGraphAddMemcpyNode,                          0)        \
    ACTION( cuda,        505,   cuGraphMemcpyNodeGetParams,                    0)        \
    ACTION( cuda,        506,   cuGraphAddMemsetNode,                          0)        \
    ACTION( cuda,        507,   cuGraphMemsetNodeGetParams,                    0)        \
    ACTION( cuda,        508,   cuGraphMemsetNodeSetParams,                    0)        \
    ACTION( cuda,        509,   cuGraphNodeGetType,                            0)        \
    ACTION( cuda,        510,   cuGraphGetRootNodes,                           0)        \
    ACTION( cuda,        511,   cuGraphNodeGetDependencies,                    0)        \
    ACTION( cuda,        512,   cuGraphNodeGetDependentNodes,                  0)        \
    ACTION( cuda,        513,   cuGraphInstantiate,                            0)        \
    ACTION( cuda,        514,   cuGraphLaunch,                                 0)        \
    ACTION( cuda,        515,   cuGraphLaunch_ptsz,                            0)        \
    ACTION( cuda,        516,   cuGraphExecDestroy,                            0)        \
    ACTION( cuda,        517,   cuGraphDestroy,                                0)        \
    ACTION( cuda,        518,   cuGraphAddDependencies,                        0)        \
    ACTION( cuda,        519,   cuGraphRemoveDependencies,                     0)        \
    ACTION( cuda,        520,   cuGraphMemcpyNodeSetParams,                    0)        \
    ACTION( cuda,        521,   cuGraphKernelNodeSetParams,                    0)        \
    ACTION( cuda,        522,   cuGraphDestroyNode,                            0)        \
    ACTION( cuda,        523,   cuGraphClone,                                  0)        \
    ACTION( cuda,        524,   cuGraphNodeFindInClone,                        0)        \
    ACTION( cuda,        525,   cuGraphAddChildGraphNode,                      0)        \
    ACTION( cuda,        526,   cuGraphAddEmptyNode,                           0)        \
    ACTION( cuda,        527,   cuLaunchHostFunc,                              0)        \
    ACTION( cuda,        528,   cuLaunchHostFunc_ptsz,                         0)        \
    ACTION( cuda,        529,   cuGraphChildGraphNodeGetGraph,                 0)        \
    ACTION( cuda,        530,   cuGraphAddHostNode,                            0)        \
    ACTION( cuda,        531,   cuGraphHostNodeGetParams,                      0)        \
    ACTION( cuda,        532,   cuDeviceGetLuid,                               0)        \
    ACTION( cuda,        533,   cuGraphHostNodeSetParams,                      0)        \
    ACTION( cuda,        534,   cuGraphGetNodes,                               0)        \
    ACTION( cuda,        535,   cuGraphGetEdges,                               0)        \
    ACTION( cuda,        536,   cuStreamGetCaptureInfo,                        0)        \
    ACTION( cuda,        537,   cuStreamGetCaptureInfo_ptsz,                   0)        \
    ACTION( cuda,        538,   cuGraphExecKernelNodeSetParams,                0)        \
    ACTION( cuda,        539,   cuStreamBeginCapture_v2,                       0)        \
    ACTION( cuda,        540,   cuStreamBeginCapture_v2_ptsz,                  0)        \
    ACTION( cuda,        541,   cuThreadExchangeStreamCaptureMode,             0)        \
    ACTION( cuda,        542,   cuDeviceGetNvSciSyncAttributes,                0)        \
    ACTION( cuda,        543,   cuOccupancyAvailableDynamicSMemPerBlock,       0)        \
    ACTION( cuda,        544,   cuDevicePrimaryCtxRelease_v2,                  0)        \
    ACTION( cuda,        545,   cuDevicePrimaryCtxReset_v2,                    0)        \
    ACTION( cuda,        546,   cuDevicePrimaryCtxSetFlags_v2,                 0)        \
    ACTION( cuda,        547,   cuMemAddressReserve,                           0)        \
    ACTION( cuda,        548,   cuMemAddressFree,                              0)        \
    ACTION( cuda,        549,   cuMemCreate,                                   0)        \
    ACTION( cuda,        550,   cuMemRelease,                                  0)        \
    ACTION( cuda,        551,   cuMemMap,                                      0)        \
    ACTION( cuda,        552,   cuMemUnmap,                                    0)        \
    ACTION( cuda,        553,   cuMemSetAccess,                                0)        \
    ACTION( cuda,        554,   cuMemExportToShareableHandle,                  0)        \
    ACTION( cuda,        555,   cuMemImportFromShareableHandle,                0)        \
    ACTION( cuda,        556,   cuMemGetAllocationGranularity,                 0)        \
    ACTION( cuda,        557,   cuMemGetAllocationPropertiesFromHandle,        0)        \
    ACTION( cuda,        558,   cuMemGetAccess,                                0)        \
    ACTION( cuda,        559,   cuStreamSetFlags,                              0)        \
    ACTION( cuda,        560,   cuStreamSetFlags_ptsz,                         0)        \
    ACTION( cuda,        561,   cuGraphExecUpdate,                             0)        \
    ACTION( cuda,        562,   cuGraphExecMemcpyNodeSetParams,                0)        \
    ACTION( cuda,        563,   cuGraphExecMemsetNodeSetParams,                0)        \
    ACTION( cuda,        564,   cuGraphExecHostNodeSetParams,                  0)        \
    ACTION( cuda,        565,   cuMemRetainAllocationHandle,                   0)        \
    ACTION( cuda,        566,   cuFuncGetModule,                               0)        \
    ACTION( cuda,        567,   cuIpcOpenMemHandle_v2,                         0)        \
    ACTION( cuda,        568,   cuCtxResetPersistingL2Cache,                   0)        \
    ACTION( cuda,        569,   cuGraphKernelNodeCopyAttributes,               0)        \
    ACTION( cuda,        570,   cuGraphKernelNodeGetAttribute,                 0)        \
    ACTION( cuda,        571,   cuGraphKernelNodeSetAttribute,                 0)        \
    ACTION( cuda,        572,   cuStreamCopyAttributes,                        0)        \
    ACTION( cuda,        573,   cuStreamCopyAttributes_ptsz,                   0)        \
    ACTION( cuda,        574,   cuStreamGetAttribute,                          0)        \
    ACTION( cuda,        575,   cuStreamGetAttribute_ptsz,                     0)        \
    ACTION( cuda,        576,   cuStreamSetAttribute,                          0)        \
    ACTION( cuda,        577,   cuStreamSetAttribute_ptsz,                     0)        \
    ACTION( cuda,        578,   cuGraphInstantiate_v2,                         0)        \
    ACTION( cuda,        579,   cuDeviceGetTexture1DLinearMaxWidth,            0)        \
    ACTION( cuda,        580,   cuGraphUpload,                                 0)        \
    ACTION( cuda,        581,   cuGraphUpload_ptsz,                            0)        \
    ACTION( cuda,        582,   cuArrayGetSparseProperties,                    0)        \
    ACTION( cuda,        583,   cuMipmappedArrayGetSparseProperties,           0)        \
    ACTION( cuda,        584,   cuMemMapArrayAsync,                            0)        \
    ACTION( cuda,        585,   cuMemMapArrayAsync_ptsz,                       0)        \
    ACTION( cuda,        586,   cuGraphExecChildGraphNodeSetParams,            0)        \
    ACTION( cuda,        587,   cuEventRecordWithFlags,                        0)        \
    ACTION( cuda,        588,   cuEventRecordWithFlags_ptsz,                   0)        \
    ACTION( cuda,        589,   cuGraphAddEventRecordNode,                     0)        \
    ACTION( cuda,        590,   cuGraphAddEventWaitNode,                       0)        \
    ACTION( cuda,        591,   cuGraphEventRecordNodeGetEvent,                0)        \
    ACTION( cuda,        592,   cuGraphEventWaitNodeGetEvent,                  0)        \
    ACTION( cuda,        593,   cuGraphEventRecordNodeSetEvent,                0)        \
    ACTION( cuda,        594,   cuGraphEventWaitNodeSetEvent,                  0)        \
    ACTION( cuda,        595,   cuGraphExecEventRecordNodeSetEvent,            0)        \
    ACTION( cuda,        596,   cuGraphExecEventWaitNodeSetEvent,              0)        \
    ACTION( cuda,        597,   cuArrayGetPlane,                               0)        \
    ACTION( cuda,        598,   cuMemAllocAsync,                               0)        \
    ACTION( cuda,        599,   cuMemAllocAsync_ptsz,                          0)        \
    ACTION( cuda,        600,   cuMemFreeAsync,                                0)        \
    ACTION( cuda,        601,   cuMemFreeAsync_ptsz,                           0)        \
    ACTION( cuda,        602,   cuMemPoolTrimTo,                               0)        \
    ACTION( cuda,        603,   cuMemPoolSetAttribute,                         0)        \
    ACTION( cuda,        604,   cuMemPoolGetAttribute,                         0)        \
    ACTION( cuda,        605,   cuMemPoolSetAccess,                            0)        \
    ACTION( cuda,        606,   cuDeviceGetDefaultMemPool,                     0)        \
    ACTION( cuda,        607,   cuMemPoolCreate,                               0)        \
    ACTION( cuda,        608,   cuMemPoolDestroy,                              0)        \
    ACTION( cuda,        609,   cuDeviceSetMemPool,                            0)        \
    ACTION( cuda,        610,   cuDeviceGetMemPool,                            0)        \
    ACTION( cuda,        611,   cuMemAllocFromPoolAsync,                       0)        \
    ACTION( cuda,        612,   cuMemAllocFromPoolAsync_ptsz,                  0)        \
    ACTION( cuda,        613,   cuMemPoolExportToShareableHandle,              0)        \
    ACTION( cuda,        614,   cuMemPoolImportFromShareableHandle,            0)        \
    ACTION( cuda,        615,   cuMemPoolExportPointer,                        0)        \
    ACTION( cuda,        616,   cuMemPoolImportPointer,                        0)        \
    ACTION( cuda,        617,   cuMemPoolGetAccess,                            0)        \
    ACTION( cuda,        618,   cuGraphAddExternalSemaphoresSignalNode,        0)        \
    ACTION( cuda,        619,   cuGraphExternalSemaphoresSignalNodeGetParams,  0)        \
    ACTION( cuda,        620,   cuGraphExternalSemaphoresSignalNodeSetParams,  0)        \
    ACTION( cuda,        621,   cuGraphAddExternalSemaphoresWaitNode,          0)        \
    ACTION( cuda,        622,   cuGraphExternalSemaphoresWaitNodeGetParams,    0)        \
    ACTION( cuda,        623,   cuGraphExternalSemaphoresWaitNodeSetParams,    0)        \
    ACTION( cuda,        624,   cuGraphExecExternalSemaphoresSignalNodeSetParams, 0)     \
    ACTION( cuda,        625,   cuGraphExecExternalSemaphoresWaitNodeSetParams, 0)       \
    ACTION( cuda,        626,   cuGetProcAddress,                              0)        \
    ACTION( cuda,        627,   cuFlushGPUDirectRDMAWrites,                    0)        \
    ACTION( cuda,        628,   cuGraphDebugDotPrint,                          0)        \
    ACTION( cuda,        629,   cuStreamGetCaptureInfo_v2,                     0)        \
    ACTION( cuda,        630,   cuStreamGetCaptureInfo_v2_ptsz,                0)        \
    ACTION( cuda,        631,   cuStreamUpdateCaptureDependencies,             0)        \
    ACTION( cuda,        632,   cuStreamUpdateCaptureDependencies_ptsz,        0)        \
    ACTION( cuda,        633,   cuUserObjectCreate,                            0)        \
    ACTION( cuda,        634,   cuUserObjectRetain,                            0)        \
    ACTION( cuda,        635,   cuUserObjectRelease,                           0)        \
    ACTION( cuda,        636,   cuGraphRetainUserObject,                       0)        \
    ACTION( cuda,        637,   cuGraphReleaseUserObject,                      0)        \
    ACTION( cuda,        638,   cuGraphAddMemAllocNode,                        0)        \
    ACTION( cuda,        639,   cuGraphAddMemFreeNode,                         0)        \
    ACTION( cuda,        640,   cuDeviceGraphMemTrim,                          0)        \
    ACTION( cuda,        641,   cuDeviceGetGraphMemAttribute,                  0)        \
    ACTION( cuda,        642,   cuDeviceSetGraphMemAttribute,                  0)        \
    ACTION( cuda,        643,   cuGraphInstantiateWithFlags,                   0)        \
    ACTION( cuda,        644,   cuDeviceGetExecAffinitySupport,                0)        \
    ACTION( cuda,        645,   cuCtxCreate_v3,                                0)        \
    ACTION( cuda,        646,   cuCtxGetExecAffinity,                          0)        \
    ACTION( cuda,        647,   cuDeviceGetUuid_v2,                            0)        \
    ACTION( cuda,        648,   cuGraphMemAllocNodeGetParams,                  0)        \
    ACTION( cuda,        649,   cuGraphMemFreeNodeGetParams,                   0)        \
    ACTION( cuda,        650,   cuGraphNodeSetEnabled,                         0)        \
    ACTION( cuda,        651,   cuGraphNodeGetEnabled,                         0)        \
    ACTION( cuda,        652,   cuLaunchKernelEx,                              0)        \
    ACTION( cuda,        653,   cuLaunchKernelEx_ptsz,                         0)        \
    ACTION( cudaDefMap,  654,   cuArrayGetMemoryRequirements,                  0)        \
    ACTION( cudaDefMap,  655,   cuMipmappedArrayGetMemoryRequirements,         0)        \
    ACTION( cuda,        656,   cuGraphInstantiateWithParams,                  0)        \
    ACTION( cuda,        657,   cuGraphInstantiateWithParams_ptsz,             0)        \
    ACTION( cuda,        658,   cuGraphExecGetFlags,                           0)        \
    ACTION( cuda,        659,   cuStreamWaitValue32_v2,                        0)        \
    ACTION( cuda,        660,   cuStreamWaitValue32_v2_ptsz,                   0)        \
    ACTION( cuda,        661,   cuStreamWaitValue64_v2,                        0)        \
    ACTION( cuda,        662,   cuStreamWaitValue64_v2_ptsz,                   0)        \
    ACTION( cuda,        663,   cuStreamWriteValue32_v2,                       0)        \
    ACTION( cuda,        664,   cuStreamWriteValue32_v2_ptsz,                  0)        \
    ACTION( cuda,        665,   cuStreamWriteValue64_v2,                       0)        \
    ACTION( cuda,        666,   cuStreamWriteValue64_v2_ptsz,                  0)        \
    ACTION( cuda,        667,   cuStreamBatchMemOp_v2,                         0)        \
    ACTION( cuda,        668,   cuStreamBatchMemOp_v2_ptsz,                    0)        \
    ACTION( cuda,        669,   cuGraphAddBatchMemOpNode,                      0)        \
    ACTION( cuda,        670,   cuGraphBatchMemOpNodeGetParams,                0)        \
    ACTION( cuda,        671,   cuGraphBatchMemOpNodeSetParams,                0)        \
    ACTION( cuda,        672,   cuGraphExecBatchMemOpNodeSetParams,            0)        \
    ACTION( cuda,        673,   cuModuleGetLoadingMode,                        0)        \
    ACTION( cuda,        674,   cuMemGetHandleForAddressRange,                 0)        \
    ACTION( cuda,        675,   cuOccupancyMaxPotentialClusterSize,            0)        \
    ACTION( cuda,        676,   cuOccupancyMaxActiveClusters,                  0)        \
    ACTION( cuda,        677,   cuGetProcAddress_v2,                           0)        \
    ACTION( cuda,        678,   cuLibraryLoadData,                             0)        \
    ACTION( cuda,        679,   cuLibraryLoadFromFile,                         0)        \
    ACTION( cuda,        680,   cuLibraryUnload,                               0)        \
    ACTION( cuda,        681,   cuLibraryGetKernel,                            0)        \
    ACTION( cuda,        682,   cuLibraryGetModule,                            0)        \
    ACTION( cuda,        683,   cuKernelGetFunction,                           0)        \
    ACTION( cuda,        684,   cuLibraryGetGlobal,                            0)        \
    ACTION( cuda,        685,   cuLibraryGetManaged,                           0)        \
    ACTION( cuda,        686,   cuKernelGetAttribute,                          0)        \
    ACTION( cuda,        687,   cuKernelSetAttribute,                          0)        \
    ACTION( cuda,        688,   cuKernelSetCacheConfig,                        0)        \
    ACTION( CTK3402,     689,   cuGraphAddKernelNode_v2,                       0)        \
    ACTION( CTK3402,     690,   cuGraphKernelNodeGetParams_v2,                 0)        \
    ACTION( CTK3402,     691,   cuGraphKernelNodeSetParams_v2,                 0)        \
    ACTION( CTK3402,     692,   cuGraphExecKernelNodeSetParams_v2,             0)        \
    ACTION( cuda,        693,   cuStreamGetId,								   0)		 \
    ACTION( cuda,        694,   cuStreamGetId_ptsz,							   0)		 \
    ACTION( cuda,        695,   cuCtxGetId, 								   0)		 \
    ACTION( cuda,        696,   cuGraphExecUpdate_v2,                          0)        \
    ACTION( cuda,        697,   cuTensorMapEncodeTiled,                        0)        \
    ACTION( cuda,        698,   cuTensorMapEncodeIm2col,                       0)        \
    ACTION( cuda,        699,   cuTensorMapReplaceAddress,                     0)        \
    ACTION( cuda,        700,   cuLibraryGetUnifiedFunction,                   0)        \
    ACTION( COREDUMP,    701,   cuCoredumpGetAttribute,                        0)        \
    ACTION( COREDUMP,    702,   cuCoredumpGetAttributeGlobal,                  0)        \
    ACTION( COREDUMP,    703,   cuCoredumpSetAttribute,                        0)        \
    ACTION( COREDUMP,    704,   cuCoredumpSetAttributeGlobal,                  0)        \
    ACTION( cuda,        705,   cuCtxSetFlags,                                 0)        \
    ACTION( cudaMltcst,  706,   cuMulticastCreate,                             0)        \
    ACTION( cudaMltcst,  707,   cuMulticastAddDevice,                          0)        \
    ACTION( cudaMltcst,  708,   cuMulticastBindMem,                            0)        \
    ACTION( cudaMltcst,  709,   cuMulticastBindAddr,                           0)        \
    ACTION( cudaMltcst,  710,   cuMulticastUnbind,                             0)        \
    ACTION( cudaMltcst,  711,   cuMulticastGetGranularity,                     0)        \
    ACTION( cudaGraphPoly, 712,   cuGraphAddNode,                              0)        \
    ACTION( cudaGraphPoly, 713,   cuGraphNodeSetParams,                        0)        \
    ACTION( cudaGraphPoly, 714,   cuGraphExecNodeSetParams,                    0)        \
    ACTION( cuda,          715,   cuMemAdvise_v2,                              0)        \
    ACTION( cuda,          716,   cuMemPrefetchAsync_v2,                       0)        \
    ACTION( cuda,          717,   cuMemPrefetchAsync_v2_ptsz,                  0)        \
    ACTION( CTK4886,       718,   cuFuncGetName,                               0)        \
    ACTION( CTK4886,       719,   cuKernelGetName,                             0)        \
    ACTION( CTK3381,       720,   cuStreamBeginCaptureToGraph,                 0)        \
    ACTION( CTK3381,       721,   cuStreamBeginCaptureToGraph_ptsz,            0)        \
    ACTION( CTK3381,       722,   cuGraphConditionalHandleCreate,              0)        \
    ACTION( cuda,          723,   cuGraphAddNode_v2,                           0)        \
    ACTION( cuda,          724,   cuGraphGetEdges_v2,                          0)        \
    ACTION( cuda,          725,   cuGraphNodeGetDependencies_v2,               0)        \
    ACTION( cuda,          726,   cuGraphNodeGetDependentNodes_v2,             0)        \
    ACTION( cuda,          727,   cuGraphAddDependencies_v2,                   0)        \
    ACTION( cuda,          728,   cuGraphRemoveDependencies_v2,                0)        \
    ACTION( cuda,          729,   cuStreamGetCaptureInfo_v3,                   0)        \
    ACTION( cuda,          730,   cuStreamGetCaptureInfo_v3_ptsz,              0)        \
    ACTION( cuda,          731,   cuStreamUpdateCaptureDependencies_v2,        0)        \
    ACTION( cuda,          732,   cuStreamUpdateCaptureDependencies_v2_ptsz,   0)        \
    ACTION( CTK4788,       733,   cuFuncGetParamInfo,                          0)        \
    ACTION( CTK4788,       734,   cuKernelGetParamInfo,                        0)        \
    ACTION( CTK5082,       735,   cuDeviceRegisterAsyncNotification,           0)        \
    ACTION( CTK5082,       736,   cuDeviceUnregisterAsyncNotification,         0)        \
    ACTION( CTK5427,       737,   cuModuleGetFunctionCount,                    0)        \
    ACTION( CTK5427,       738,   cuModuleEnumerateFunctions,                  0)        \
    ACTION( CTK5427,       739,   cuLibraryGetKernelCount,                     0)        \
    ACTION( CTK5427,       740,   cuLibraryEnumerateKernels,                   0)        \
    ACTION( CTK5427,       741,   cuFuncIsLoaded,                              0)        \
    ACTION( CTK5427,       742,   cuFuncLoad,                                  0)        \
    ACTION( cuda,          743,   cuGreenCtxCreate,                            0)        \
    ACTION( cuda,          744,   cuGreenCtxDestroy,                           0)        \
    ACTION( cuda,          745,   cuDeviceGetDevResource,                      0)        \
    ACTION( cuda,          746,   cuCtxGetDevResource,                         0)        \
    ACTION( cuda,          747,   cuGreenCtxGetDevResource,                    0)        \
    ACTION( cuda,          748,   cuDevResourceGenerateDesc,                   0)        \
    ACTION( cuda,          749,   cuGreenCtxRecordEvent,                       0)        \
    ACTION( cuda,          750,   cuGreenCtxWaitEvent,                         0)        \
    ACTION( cuda,          751,   cuDevSmResourceSplitByCount,                 0)        \
    ACTION( cuda,          752,   cuStreamGetGreenCtx,                         0)        \
    ACTION( cuda,          753,   cuCtxFromGreenCtx,                           0)        \
    ACTION( cuda,          754,   cuKernelGetLibrary,                          0)        \
    ACTION( cuda,          755,   cuCtxRecordEvent,                            0)        \
    ACTION( cuda,          756,   cuCtxWaitEvent,                              0)        \
    ACTION( cuda,          757,   cuCtxCreate_v4,                              0)        \
    ACTION( cuda,          758,   cuGreenCtxStreamCreate,                      0)        \
    ACTION( cuda,          759,   cuStreamGetCtx_v2,                           0)        \
    ACTION( cuda,          760,   cuStreamGetCtx_v2_ptsz,                      0)        \
    ACTION( CTK5022,       761,   cuMemBatchDecompressAsync,                   0)        \
    ACTION( CTK5022,       762,   cuMemBatchDecompressAsync_ptsz,              0)        \
    ACTION( CTK6259,       763,   cuLogsRegisterCallback,                      0)        \
    ACTION( CTK6259,       764,   cuLogsUnregisterCallback,                    0)        \
    ACTION( CTK6259,       765,   cuLogsCurrent,                               0)        \
    ACTION( CTK6259,       766,   cuLogsDumpToFile,                            0)        \
    ACTION( CTK6259,       767,   cuLogsDumpToMemory,                          0)        \
    ACTION( CTK6864,       768,   cuCheckpointProcessGetRestoreThreadId,       0)        \
    ACTION( CTK6864,       769,   cuCheckpointProcessGetState,                 0)        \
    ACTION( CTK6864,       770,   cuCheckpointProcessLock,                     0)        \
    ACTION( CTK6864,       771,   cuCheckpointProcessCheckpoint,               0)        \
    ACTION( CTK6864,       772,   cuCheckpointProcessRestore,                  0)        \
    ACTION( CTK6864,       773,   cuCheckpointProcessUnlock,                   0)        \
    ACTION( CTK7322,       774,   cuStreamGetDevice,                           0)        \
    ACTION( CTK7322,       775,   cuStreamGetDevice_ptsz,                      0)        \
    ACTION( CTK2174,       776,   cuMemcpyBatchAsync,                          0)        \
    ACTION( CTK2174,       777,   cuMemcpyBatchAsync_ptsz,                     0)        \
    ACTION( CTK2174,       778,   cuMemcpy3DBatchAsync,                        0)        \
    ACTION( CTK2174,       779,   cuMemcpy3DBatchAsync_ptsz,                   0)        \
    ACTION( CTK7377,       780,   cuEventElapsedTime_v2,                       0)        \
    ACTION( CTK6945,       781,   cuTensorMapEncodeIm2colWide,                 0)        \
    ACTION( CTK7666,       782,   cuGreenCtxGetId,                             0)        \
    ACTION( CTK7136,       783,   cuStreamCreateForCaptureToCig,               0)        \
    ACTION( CTK5214,       784,   cuMemPrefetchBatchAsync,                     0)        \
    ACTION( CTK5214,       785,   cuMemPrefetchBatchAsync_ptsz,                0)        \
    ACTION( CTK7486,       786,   cuSemaphoreCreate,                           0)        \
    ACTION( CTK7486,       787,   cuSemaphoreExport,                           0)        \
    ACTION( CTK7486,       788,   cuSemaphoreDestroy,                          0)        \
    ACTION( CTK5214,       789,   cuMemDiscardBatchAsync,                      0)        \
    ACTION( CTK5214,       790,   cuMemDiscardBatchAsync_ptsz,                 0)        \
    ACTION( CTK5214,       791,   cuMemDiscardAndPrefetchBatchAsync,           0)        \
    ACTION( CTK5214,       792,   cuMemDiscardAndPrefetchBatchAsync_ptsz,      0)        \
    ACTION( CTK7298,       793,   cuMultiKernelCooperativeDomainCreate,        0)        \
    ACTION( CTK7298,       794,   cuMultiKernelCooperativeDomainDestroy,       0)        \
    ACTION( CTK8438,       795,   cuCtxGetDevice_v2,                           0)        \
    ACTION( CTK8457,       796,   cuMemcpyBatchAsync_v2,                       0)        \
    ACTION( CTK8457,       797,   cuMemcpyBatchAsync_v2_ptsz,                  0)        \
    ACTION( CTK8457,       798,   cuMemcpy3DBatchAsync_v2,                     0)        \
    ACTION( CTK8457,       799,   cuMemcpy3DBatchAsync_v2_ptsz,                0)        \
    ACTION( CTK8438,       800,   cuCtxSynchronize_v2,                         0)        \
    ACTION( CTK7080,       801,   cuMemGetDefaultMemPool,                      0)        \
    ACTION( CTK7080,       802,   cuMemGetMemPool,                             0)        \
    ACTION( CTK7080,       803,   cuMemSetMemPool,                             0)        \
    ACTION( CTK7560,       804,   cuDeviceGetP2PAtomicCapabilities,            0)        \
    ACTION( CTK7560,       805,   cuDeviceGetHostAtomicCapabilities,           0)        \
    ACTION( CTK8812,       806,   cuDriverGetGpuCodeIsaVersion,                0)        \

#endif // file guard

