#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.thunar_uca"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[5102]; const double alignment; void * const ptr;}  thunar_uca_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\344\000\000\000\000\000\000\050\007\000\000\000"
  "\000\000\000\000\000\000\000\000\002\000\000\000\005\000\000\000"
  "\005\000\000\000\006\000\000\000\006\000\000\000\034\306\353\132"
  "\003\000\000\000\344\000\000\000\011\000\166\000\360\000\000\000"
  "\076\016\000\000\113\120\220\013\004\000\000\000\076\016\000\000"
  "\004\000\114\000\104\016\000\000\110\016\000\000\240\124\352\031"
  "\001\000\000\000\110\016\000\000\005\000\114\000\120\016\000\000"
  "\124\016\000\000\111\334\057\122\005\000\000\000\124\016\000\000"
  "\004\000\114\000\130\016\000\000\140\016\000\000\324\265\002\000"
  "\377\377\377\377\140\016\000\000\001\000\114\000\144\016\000\000"
  "\150\016\000\000\241\031\050\256\002\000\000\000\150\016\000\000"
  "\007\000\114\000\160\016\000\000\164\016\000\000\210\172\166\223"
  "\003\000\000\000\164\016\000\000\012\000\166\000\200\016\000\000"
  "\355\023\000\000\145\144\151\164\157\162\056\165\151\000\000\000"
  "\371\267\000\000\001\000\000\000\170\332\355\135\157\157\333\274"
  "\021\177\237\117\301\031\050\332\146\221\023\333\111\232\247\113"
  "\362\240\377\122\024\173\320\015\153\273\275\014\150\211\266\270"
  "\122\244\036\222\212\343\175\372\035\051\311\221\155\331\226\354"
  "\044\226\124\005\050\152\313\344\351\170\344\217\167\107\036\171"
  "\227\277\337\007\014\335\021\251\250\340\127\235\136\367\244\203"
  "\010\167\205\107\371\370\252\363\343\373\215\163\321\371\375\372"
  "\340\362\057\216\203\076\023\116\044\326\304\103\023\252\175\064"
  "\146\330\043\150\320\035\134\164\373\310\161\342\102\007\010\376"
  "\156\204\104\134\114\216\320\220\150\115\044\362\004\177\251\021"
  "\361\250\106\332\247\052\123\375\010\051\312\135\222\320\242\134"
  "\121\245\025\212\102\301\315\027\042\065\260\141\111\172\044\224"
  "\304\265\057\017\245\010\315\057\104\041\314\075\044\264\117\344"
  "\204\052\202\002\242\200\332\070\046\017\117\321\210\062\322\075"
  "\260\254\121\016\214\214\260\113\256\201\334\245\044\177\106\124"
  "\002\001\106\207\127\235\261\376\371\327\316\203\014\006\335\136"
  "\277\163\154\313\151\022\204\014\136\212\134\206\225\272\352\174"
  "\367\043\216\345\017\027\177\202\266\010\331\101\041\226\204\353"
  "\253\316\147\375\363\043\305\114\214\073\327\226\335\313\204\311"
  "\051\342\070\040\127\035\027\163\147\044\334\110\165\256\157\060"
  "\123\344\362\070\055\220\137\136\123\315\110\007\151\211\271\002"
  "\006\360\220\301\303\051\201\352\346\315\350\235\253\201\325\115"
  "\104\002\341\141\326\271\376\056\243\215\357\363\310\010\107\114"
  "\073\023\352\151\277\163\175\172\162\122\264\206\117\350\330\327"
  "\120\345\254\100\025\245\245\230\072\246\177\234\130\162\305\270"
  "\323\323\220\070\076\065\305\075\053\345\245\012\256\117\231\207"
  "\154\047\163\314\034\373\365\252\163\067\024\367\111\207\100\031"
  "\061\374\057\161\165\332\225\320\143\357\341\127\104\027\313\225"
  "\357\274\065\034\140\333\121\267\320\126\234\171\101\056\063\221"
  "\326\202\277\237\143\144\133\146\240\326\161\374\202\271\147\041"
  "\166\177\002\076\326\323\047\367\041\240\152\055\361\345\112\000"
  "\064\126\262\112\050\024\065\262\351\134\237\254\152\302\022\277"
  "\227\307\126\254\213\122\137\057\330\257\102\223\241\020\077\343"
  "\256\346\351\267\365\334\335\121\105\001\163\371\303\263\100\327"
  "\224\251\066\024\322\043\062\205\336\371\312\152\113\155\265\117"
  "\315\304\314\035\127\260\050\340\352\152\000\237\245\230\250\253"
  "\013\073\043\057\224\135\222\315\147\111\275\130\056\143\370\324"
  "\353\054\326\330\122\060\333\217\333\042\022\352\365\313\324\005"
  "\151\070\012\106\022\014\244\065\302\315\345\330\312\364\241\362"
  "\206\367\346\166\117\276\330\377\300\103\302\222\361\010\257\272"
  "\145\366\173\136\335\035\072\140\327\116\310\253\037\063\232\247"
  "\226\156\277\102\201\267\145\351\105\212\070\021\207\276\145\224"
  "\157\331\244\200\223\100\160\352\232\321\061\046\240\041\254\104"
  "\101\265\310\151\131\122\367\230\321\361\352\011\051\123\021\273"
  "\256\261\065\206\224\321\125\145\254\225\001\062\202\051\016\031"
  "\375\225\010\017\304\017\146\203\306\022\170\115\172\337\362\032"
  "\033\034\071\104\216\067\276\053\157\256\137\077\347\257\354\136"
  "\062\322\016\326\032\273\176\021\051\054\152\151\021\026\255\234"
  "\063\267\257\234\343\267\001\330\047\053\322\007\200\305\042\176"
  "\136\200\155\123\135\013\301\064\015\035\115\356\165\056\314\276"
  "\203\125\153\212\042\061\262\026\156\154\137\300\107\254\301\354"
  "\145\014\054\156\344\121\005\106\353\224\030\153\304\026\162\005"
  "\067\004\301\076\346\121\267\054\113\176\152\020\154\323\036\303"
  "\336\035\330\317\312\111\314\305\042\144\236\150\074\367\152\074"
  "\236\063\012\003\214\150\127\322\320\232\225\115\320\033\037\037"
  "\332\123\011\365\221\225\157\115\264\310\022\313\015\123\046\275"
  "\312\050\223\145\111\067\104\247\144\032\126\114\265\140\205\022"
  "\302\251\226\121\032\353\110\015\261\104\023\237\160\244\010\003"
  "\061\232\345\030\363\043\325\044\100\043\051\202\126\041\075\216"
  "\102\352\125\106\041\251\150\170\153\072\262\021\332\350\133\064"
  "\064\155\251\204\046\232\011\266\046\152\150\236\337\206\351\240"
  "\176\145\164\320\202\230\033\242\200\124\014\074\243\114\046\076"
  "\165\375\254\012\132\322\076\135\364\007\301\167\004\221\040\204"
  "\267\214\354\156\103\254\114\320\017\105\320\313\343\227\361\103"
  "\242\314\176\201\371\101\265\152\246\216\303\076\243\146\134\021"
  "\004\320\037\215\320\062\037\342\266\124\102\313\244\162\255\211"
  "\222\231\143\267\141\072\146\260\137\260\315\266\303\206\342\276"
  "\127\111\204\255\154\314\106\245\071\077\154\126\221\330\261\175"
  "\217\240\073\267\326\237\111\003\321\053\312\135\026\171\251\337"
  "\305\211\301\001\226\123\263\123\015\324\064\221\352\065\170\156"
  "\010\136\000\270\012\062\152\266\213\276\021\222\270\147\061\255"
  "\131\025\304\310\230\300\003\100\243\230\130\325\212\021\243\112"
  "\033\127\121\105\141\050\244\335\227\237\025\277\303\222\032\376"
  "\324\121\242\314\123\015\016\132\136\151\252\043\033\103\140\274"
  "\104\206\043\016\275\232\160\233\274\270\213\376\143\176\003\302"
  "\104\072\056\006\215\316\154\034\201\102\257\110\167\334\105\057"
  "\156\216\320\213\217\360\357\353\153\204\045\101\060\055\172\107"
  "\171\006\003\016\103\106\135\303\011\042\167\100\221\216\120\040"
  "\244\151\044\006\067\227\047\156\051\125\211\263\152\014\213\117"
  "\060\016\227\110\011\316\246\013\364\200\024\271\207\062\360\103"
  "\056\241\155\072\272\224\311\361\150\146\307\246\331\160\363\214"
  "\270\365\066\362\346\055\345\155\045\261\161\167\271\340\304\272"
  "\166\162\335\146\116\212\267\371\347\047\245\141\374\254\136\263"
  "\222\204\231\205\336\225\037\152\133\314\157\357\315\216\066\231"
  "\105\364\040\065\125\006\156\060\213\305\160\103\200\346\004\232"
  "\261\361\040\314\224\140\347\051\033\156\224\314\157\205\170\123"
  "\140\317\140\226\212\011\110\376\044\136\007\301\174\341\061\042"
  "\201\127\033\000\164\033\271\370\226\330\020\240\333\264\023\147"
  "\145\325\004\170\041\136\314\373\361\232\127\255\035\071\371\243"
  "\347\113\200\307\044\036\074\324\174\354\165\326\325\177\204\201"
  "\363\030\152\173\025\035\352\012\356\230\217\235\153\017\310\201"
  "\233\246\035\050\300\035\065\015\206\002\304\131\214\360\246\271"
  "\153\003\200\033\075\371\365\236\170\362\123\172\312\310\112\312"
  "\166\334\246\126\062\345\006\035\053\015\366\225\224\252\350\025"
  "\017\252\263\370\352\203\355\345\106\272\011\156\361\337\311\164"
  "\050\260\364\320\355\267\244\125\373\160\220\013\272\264\125\364"
  "\037\117\253\343\077\366\233\340\077\146\155\265\031\320\032\142"
  "\254\155\255\232\012\171\243\077\123\050\247\142\113\214\061\122"
  "\312\026\333\331\075\052\155\314\315\172\271\244\065\327\372\117"
  "\373\360\237\062\275\105\240\037\133\067\152\075\060\077\030\051"
  "\131\020\256\202\347\123\373\112\013\035\266\027\227\251\337\020"
  "\227\311\210\324\261\162\154\335\244\326\115\252\244\233\264\147"
  "\173\364\203\117\334\171\175\301\327\353\210\342\256\212\331\145"
  "\376\246\261\324\121\210\276\012\115\107\311\322\123\131\151\355"
  "\163\133\176\113\233\260\264\332\371\304\355\202\271\325\056\042"
  "\216\060\243\043\064\025\021\232\140\256\021\206\377\250\215\023"
  "\163\043\251\214\032\022\166\247\300\027\023\033\012\300\346\226"
  "\343\201\106\274\145\140\326\352\277\033\222\106\147\061\045\220"
  "\117\307\076\233\042\150\225\010\002\002\076\240\227\276\306\067"
  "\241\002\126\120\110\151\002\356\035\274\053\224\146\103\300\222"
  "\044\226\077\033\054\015\245\045\232\120\356\211\011\012\060\007"
  "\155\041\113\307\015\170\022\117\034\040\141\106\204\220\165\335"
  "\367\077\255\314\012\207\121\171\215\330\364\377\342\126\044\302"
  "\331\112\064\236\010\313\322\042\214\321\120\321\377\031\373\203"
  "\173\325\217\026\310\064\265\141\261\002\347\173\136\353\311\250"
  "\325\254\220\167\105\311\127\201\014\271\172\353\321\047\011\222"
  "\373\140\234\245\130\213\306\262\236\337\377\062\122\213\167\307"
  "\212\237\005\062\317\260\347\321\164\323\054\243\147\355\031\043"
  "\327\027\212\100\221\241\270\043\345\343\347\022\260\053\143\046"
  "\155\254\134\332\225\264\203\256\204\003\131\105\045\173\136\235"
  "\365\332\101\035\224\353\135\251\220\314\365\316\054\240\302\045"
  "\276\140\240\132\217\037\177\331\152\047\352\125\124\067\157\312"
  "\126\116\316\152\077\157\374\350\212\263\360\157\162\316\302\347"
  "\103\142\376\074\174\277\026\240\050\065\317\256\073\034\077\050"
  "\315\372\302\001\371\363\307\336\200\131\134\273\033\354\151\161"
  "\167\353\005\252\220\336\203\111\032\033\314\203\376\066\024\262"
  "\101\022\366\352\023\360\055\115\340\136\241\345\206\125\004\157"
  "\143\216\316\366\021\030\126\156\116\332\064\057\125\154\167\042"
  "\343\267\132\033\367\264\156\003\166\265\145\156\266\365\106\202"
  "\061\061\261\153\065\213\041\242\252\150\214\147\154\140\276\335"
  "\206\271\211\304\341\366\342\051\354\175\076\371\250\357\075\303"
  "\250\337\126\043\357\033\061\147\365\104\314\365\213\321\023\217"
  "\111\263\052\242\265\244\340\374\021\265\166\243\147\126\054\355"
  "\370\370\206\056\004\226\102\144\057\323\141\336\272\115\266\034"
  "\012\312\305\346\066\262\204\300\111\367\342\144\376\357\164\355"
  "\246\335\361\146\276\253\016\270\136\265\101\163\136\127\320\334"
  "\264\240\151\056\150\052\256\151\336\324\025\064\136\013\232\346"
  "\202\146\120\155\320\134\324\025\064\037\133\320\064\027\064\247"
  "\325\006\315\157\165\005\015\157\101\323\134\320\234\125\033\064"
  "\275\223\272\242\346\153\213\232\346\242\346\274\342\250\351\065"
  "\147\305\331\254\026\207\330\134\345\057\222\263\277\122\351\331"
  "\011\373\070\330\101\110\344\121\011\017\304\346\313\113\366\006"
  "\273\272\203\246\337\360\345\263\136\277\171\240\061\327\063\042"
  "\314\330\074\136\342\214\031\051\142\050\121\055\146\252\212\231"
  "\212\257\236\365\006\315\301\314\114\203\330\350\070\114\171\272"
  "\127\371\020\117\107\025\240\112\251\070\216\256\302\173\075\277"
  "\074\154\052\276\176\326\073\155\036\154\114\042\246\034\340\250"
  "\030\071\346\202\246\014\164\156\132\350\124\025\072\025\137\105"
  "\353\235\065\313\112\313\161\147\154\324\365\053\223\036\113\104"
  "\332\232\161\257\133\270\124\025\056\125\137\077\073\157\026\134"
  "\226\200\242\346\221\242\132\250\124\026\052\373\135\064\253\160"
  "\250\177\113\275\075\142\121\257\043\026\353\305\336\122\154\051"
  "\376\222\024\363\047\224\334\302\111\246\330\370\314\062\130\071"
  "\235\315\151\072\227\154\273\252\046\352\134\155\302\275\307\152"
  "\335\205\236\253\046\344\325\223\361\322\124\212\207\116\201\064"
  "\264\053\047\304\065\175\125\064\347\352\371\026\071\127\007\155"
  "\316\325\147\317\271\152\107\351\240\346\327\111\334\230\265\351"
  "\177\142\163\057\172\065\256\225\010\143\136\124\135\062\111\314"
  "\363\333\346\137\335\101\145\256\313\274\260\040\346\006\244\053"
  "\372\144\162\274\147\062\040\244\055\234\277\171\301\044\045\060"
  "\173\260\236\071\035\027\000\314\314\141\070\355\223\271\173\366"
  "\314\065\107\021\363\346\157\152\210\363\053\314\255\167\164\321"
  "\227\370\056\043\025\022\227\216\246\013\151\014\022\016\020\120"
  "\047\161\042\004\313\233\111\112\240\120\020\301\107\163\056\217"
  "\230\303\172\366\124\036\325\076\174\015\050\314\266\202\247\131"
  "\025\016\273\372\136\377\355\260\353\011\367\165\015\262\045\345"
  "\164\334\252\016\073\154\363\315\356\250\054\173\157\152\256\055"
  "\377\205\371\230\240\127\200\103\047\300\367\257\053\241\060\245"
  "\341\251\056\332\062\303\154\233\135\366\211\124\145\126\306\015"
  "\320\223\137\106\163\331\204\022\125\147\150\300\134\217\214\362"
  "\303\123\244\047\002\331\273\147\045\111\266\215\217\020\261\012"
  "\326\246\057\212\002\042\251\213\031\262\262\101\175\147\140\125"
  "\241\321\243\304\156\055\163\001\272\056\240\132\035\305\172\125"
  "\151\151\066\241\037\364\252\315\021\330\352\263\075\353\263\136"
  "\305\364\331\105\275\365\331\273\060\044\130\052\163\303\145\222"
  "\147\031\340\224\304\140\250\267\073\334\352\027\120\317\143\277"
  "\122\316\204\176\235\057\066\032\154\171\261\321\151\035\106\177"
  "\000\226\007\230\153\366\136\243\115\013\101\273\055\102\025\131"
  "\210\072\275\170\354\313\215\226\256\047\316\304\123\225\277\313"
  "\176\215\355\373\061\023\247\165\170\270\315\136\156\303\122\130"
  "\370\073\137\074\276\205\073\220\107\246\374\135\301\317\260\333"
  "\337\264\073\231\226\160\206\043\217\212\133\153\153\076\052\316"
  "\336\031\272\310\254\313\252\026\144\055\104\152\164\040\146\011"
  "\042\366\266\275\047\200\210\275\320\257\205\310\343\102\304\166"
  "\226\363\220\315\002\006\132\213\264\212\036\243\131\102\232\161"
  "\362\237\000\150\337\315\035\317\055\316\232\257\212\172\115\267"
  "\326\356\250\107\236\302\132\373\267\241\333\102\244\205\110\375"
  "\255\065\141\226\303\237\000\042\377\260\333\325\055\104\132\210"
  "\124\334\314\152\343\330\053\264\242\076\250\305\212\372\332\154"
  "\030\247\115\310\136\274\170\171\176\355\116\036\227\312\040\223"
  "\333\212\135\011\044\133\020\322\336\232\124\344\024\123\233\001"
  "\240\310\166\143\233\332\270\330\046\365\157\115\312\036\140\157"
  "\320\030\307\221\211\052\115\105\025\347\236\122\310\332\125\046"
  "\333\243\353\147\263\120\331\130\112\154\367\272\323\374\125\366"
  "\112\216\044\067\243\232\313\146\245\114\102\310\244\300\054\044"
  "\323\204\210\304\061\223\224\170\010\253\114\330\246\242\101\310"
  "\026\313\077\004\111\016\247\033\102\044\321\215\211\323\344\051"
  "\257\346\272\235\071\116\347\062\155\301\373\360\354\306\252\221"
  "\325\366\107\010\153\304\010\066\334\160\142\112\100\055\225\341"
  "\305\006\156\002\314\023\231\330\303\341\161\251\005\112\135\364"
  "\056\311\342\205\031\233\036\331\100\121\350\316\131\260\250\215"
  "\113\315\210\065\215\304\341\154\232\362\154\142\116\135\350\111"
  "\014\314\303\160\367\224\171\223\365\050\272\007\007\207\207\126"
  "\262\060\066\264\010\346\372\306\304\327\300\034\113\155\202\317"
  "\105\001\230\000\241\041\226\335\112\247\172\130\256\074\335\147"
  "\236\210\322\051\356\353\230\021\271\212\126\353\131\375\255\326"
  "\263\066\207\133\353\230\355\162\277\113\173\300\270\245\370\074"
  "\007\143\313\034\354\054\244\224\312\037\352\334\351\000\156\277"
  "\176\007\160\343\220\121\314\135\202\076\314\014\357\247\074\220"
  "\133\320\230\170\206\163\274\171\155\311\157\307\066\346\130\171"
  "\023\254\264\244\162\232\272\320\314\371\046\146\176\274\074\326"
  "\004\374\034\160\151\256\017\056\217\251\211\254\037\001\214\257"
  "\017\376\017\340\365\260\134\000\050\165\165\141\171\051\157\162"
  "\147\057\000\000\002\000\000\000\170\146\143\145\057\000\000\000"
  "\005\000\000\000\165\143\141\057\006\000\000\000\000\000\000\000"
  "\057\000\000\000\001\000\000\000\164\150\165\156\141\162\057\000"
  "\003\000\000\000\143\150\157\157\163\145\162\056\165\151\000\000"
  "\154\034\000\000\001\000\000\000\170\332\315\131\115\163\333\066"
  "\020\275\373\127\240\070\244\207\206\242\323\214\073\235\104\122"
  "\306\166\344\214\247\256\065\143\313\351\264\027\015\104\256\110"
  "\324\040\300\002\240\076\372\353\273\000\145\305\266\110\212\212"
  "\053\333\276\130\037\273\213\335\267\017\017\113\250\373\151\221"
  "\011\062\003\155\270\222\075\372\256\163\110\011\310\110\305\134"
  "\046\075\172\063\072\013\176\245\237\372\007\335\037\202\340\200"
  "\340\337\231\322\104\252\371\133\062\001\153\101\223\130\311\037"
  "\055\201\230\133\142\123\156\310\234\333\224\044\202\305\360\226"
  "\030\056\043\050\337\020\056\015\067\326\220\042\127\322\275\001"
  "\155\161\005\037\062\206\134\103\304\054\304\044\327\052\167\337"
  "\200\041\114\306\104\331\024\364\234\033\040\031\030\214\226\224"
  "\341\361\123\062\345\002\072\007\101\200\251\161\211\211\114\131"
  "\004\175\014\327\325\360\117\301\065\006\020\174\322\243\211\275"
  "\375\211\176\053\357\175\347\335\317\064\364\166\026\262\134\340"
  "\242\044\022\314\230\036\035\245\205\144\372\046\142\247\251\122"
  "\230\036\045\071\323\040\155\217\176\261\267\237\071\023\052\241"
  "\175\237\157\167\225\345\222\110\226\101\217\306\060\145\205\260"
  "\301\234\307\066\245\375\243\303\303\156\170\147\322\354\221\002"
  "\117\122\113\373\357\217\266\272\330\145\016\101\212\245\322\176"
  "\354\223\331\352\300\255\000\112\254\146\322\140\235\154\042\360"
  "\303\045\030\332\077\055\214\125\031\071\216\054\142\142\266\347"
  "\152\254\126\313\300\041\037\224\220\320\376\110\027\260\341\030"
  "\245\134\304\304\167\103\062\021\370\267\075\072\233\250\305\012"
  "\070\264\121\223\277\041\262\167\230\043\262\047\370\055\341\217"
  "\355\320\022\011\107\004\233\200\040\314\372\216\133\225\023\327"
  "\357\265\205\137\340\333\373\272\350\367\055\066\313\233\050\035"
  "\203\276\353\335\057\217\213\252\163\063\071\213\220\217\330\272"
  "\266\036\063\156\070\366\000\261\273\272\031\324\072\155\324\124"
  "\135\327\171\306\022\240\217\355\066\027\345\221\222\201\173\171"
  "\307\232\200\313\251\322\031\163\255\257\113\242\066\220\341\377"
  "\142\240\243\135\374\132\125\135\345\270\144\202\047\222\366\017"
  "\073\207\365\156\335\260\104\346\021\210\141\005\212\155\221\275"
  "\160\224\153\201\254\247\146\345\366\372\123\025\044\142\222\040"
  "\142\123\236\024\032\025\246\334\160\254\334\160\110\146\144\364"
  "\234\013\144\166\236\003\323\270\145\326\222\106\062\046\261\265"
  "\332\070\167\013\013\213\312\047\013\103\260\151\044\302\345\031"
  "\332\336\162\031\033\242\246\336\301\164\016\016\116\123\210\156"
  "\175\210\067\302\176\144\044\325\060\355\321\324\332\334\174\010"
  "\303\130\105\246\263\230\106\320\121\072\011\335\213\320\172\255"
  "\013\313\274\202\125\136\364\115\142\077\242\161\201\053\132\117"
  "\020\027\055\144\356\143\277\076\303\234\204\000\157\355\226\177"
  "\120\026\061\014\365\024\323\331\245\311\205\201\040\143\372\266"
  "\310\253\045\245\311\167\321\206\040\115\274\172\036\036\317\065"
  "\313\267\171\265\246\361\246\341\206\221\327\315\314\321\004\265"
  "\332\356\054\230\147\332\213\305\076\044\163\015\241\155\350\164"
  "\333\155\272\051\354\215\052\175\370\054\275\116\141\221\343\330"
  "\262\273\343\254\265\243\353\256\325\000\144\306\141\356\065\002"
  "\133\355\006\043\267\373\005\116\130\156\143\162\234\155\314\203"
  "\326\067\303\133\015\361\165\244\335\166\217\377\100\271\121\163"
  "\132\345\364\004\354\252\234\333\242\320\134\111\165\065\043\004"
  "\355\053\142\126\016\033\016\102\207\040\255\013\120\325\134\034"
  "\143\265\011\326\025\236\035\137\134\157\115\363\311\030\371\000"
  "\006\045\213\211\225\273\126\163\057\331\063\067\061\123\222\042"
  "\144\002\064\326\344\105\175\134\104\154\034\225\043\354\330\215"
  "\345\343\110\360\350\326\131\232\271\073\157\174\365\005\116\206"
  "\141\303\202\216\146\243\341\347\341\007\142\300\026\271\023\376"
  "\042\303\243\013\307\161\250\044\326\303\266\154\014\201\006\126"
  "\347\106\003\340\165\135\273\156\345\273\011\163\246\142\304\370"
  "\313\350\267\361\365\340\142\160\072\072\037\136\216\257\317\057"
  "\277\134\264\302\174\023\367\010\221\116\266\041\276\056\164\274"
  "\066\157\017\173\335\111\260\165\270\151\033\240\301\271\336\261"
  "\326\311\263\144\122\130\353\206\232\247\252\315\110\051\061\141"
  "\272\245\314\050\315\357\206\224\262\305\303\253\363\301\345\350"
  "\330\067\371\353\340\152\164\176\172\174\261\253\374\074\111\273"
  "\154\231\177\140\354\122\254\150\067\032\016\057\116\216\257\306"
  "\347\247\303\313\353\135\343\335\033\270\135\054\027\003\331\373"
  "\327\140\174\162\063\032\015\057\167\015\147\122\247\032\132\073"
  "\041\237\062\141\140\153\000\327\134\026\307\253\006\327\156\372"
  "\235\165\030\161\072\361\041\113\045\306\045\306\345\022\073\150"
  "\261\003\333\362\074\160\003\162\345\014\176\214\211\063\042\335"
  "\021\171\177\110\355\074\217\134\327\077\204\271\023\072\300\222"
  "\003\263\314\046\012\205\171\167\371\137\313\171\223\014\071\124"
  "\167\326\375\357\326\216\025\133\374\045\320\236\351\342\117\264"
  "\377\237\057\203\362\376\312\075\252\151\167\303\041\226\244\124"
  "\162\210\137\013\165\040\303\110\031\022\307\130\377\157\257\374"
  "\371\276\301\341\251\004\322\220\251\031\354\233\102\061\066\326"
  "\302\036\110\364\331\007\176\345\064\362\012\124\002\275\157\022"
  "\255\200\176\166\032\171\022\341\320\272\147\036\025\371\036\070"
  "\364\273\313\275\221\101\276\262\045\121\022\010\236\346\057\316"
  "\247\104\005\105\276\157\046\041\324\057\303\042\174\360\225\173"
  "\327\043\134\343\145\230\124\126\367\252\270\344\122\332\273\056"
  "\071\300\237\217\117\333\237\254\126\343\223\214\077\254\037\247"
  "\126\217\023\025\244\153\276\054\134\207\162\367\100\337\256\001"
  "\323\211\132\074\212\125\177\227\130\023\143\352\256\006\357\005"
  "\171\030\340\036\000\335\360\356\267\265\376\101\067\274\367\353"
  "\334\177\071\023\376\022\000\050\165\165\141\171\051" };

static GStaticResource static_resource = { thunar_uca_resource_data.data, sizeof (thunar_uca_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_MODULE_EXPORT
GResource *thunar_uca_get_resource (void);
GResource *thunar_uca_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(thunar_ucaresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(thunar_ucaresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(thunar_ucaresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(thunar_ucaresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void thunar_ucaresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void thunar_ucaresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
