/* camellia_aesni.S ver 1.2
 *
 * Copyright © 2012-2013 Jussi Kivilinna <jussi.kivilinna@iki.fi>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

 /* Adapted to VeraCrypt
   - original file pre-processed using "gcc -E"
   - added instructions at begining of each functiont to adapt to Windows parameters passing convention
   - Fix "'ADDR32' relocation" error when building Windows driver by explicitely using %rip addressing when
     accessing various locally defined data variables. This has no performance impact.
 */ 

.data
.align 16


.Lshufb_16x16b:
 .byte 0 + (0), 4 + (0), 8 + (0), 12 + (0), 0 + (1), 4 + (1), 8 + (1), 12 + (1), 0 + (2), 4 + (2), 8 + (2), 12 + (2), 0 + (3), 4 + (3), 8 + (3), 12 + (3);

.Lpack_bswap:
 .long 0x00010203
 .long 0x04050607
 .long 0x80808080
 .long 0x80808080


.Lbswap128_mask:
 .byte 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0

.Lpre_tf_lo_s1:
 .byte 0x45, 0xe8, 0x40, 0xed, 0x2e, 0x83, 0x2b, 0x86
 .byte 0x4b, 0xe6, 0x4e, 0xe3, 0x20, 0x8d, 0x25, 0x88
.Lpre_tf_hi_s1:
 .byte 0x00, 0x51, 0xf1, 0xa0, 0x8a, 0xdb, 0x7b, 0x2a
 .byte 0x09, 0x58, 0xf8, 0xa9, 0x83, 0xd2, 0x72, 0x23

.Lpre_tf_lo_s4:
 .byte 0x45, 0x40, 0x2e, 0x2b, 0x4b, 0x4e, 0x20, 0x25
 .byte 0x14, 0x11, 0x7f, 0x7a, 0x1a, 0x1f, 0x71, 0x74
.Lpre_tf_hi_s4:
 .byte 0x00, 0xf1, 0x8a, 0x7b, 0x09, 0xf8, 0x83, 0x72
 .byte 0xad, 0x5c, 0x27, 0xd6, 0xa4, 0x55, 0x2e, 0xdf

.Lpost_tf_lo_s1:
 .byte 0x3c, 0xcc, 0xcf, 0x3f, 0x32, 0xc2, 0xc1, 0x31
 .byte 0xdc, 0x2c, 0x2f, 0xdf, 0xd2, 0x22, 0x21, 0xd1
.Lpost_tf_hi_s1:
 .byte 0x00, 0xf9, 0x86, 0x7f, 0xd7, 0x2e, 0x51, 0xa8
 .byte 0xa4, 0x5d, 0x22, 0xdb, 0x73, 0x8a, 0xf5, 0x0c

.Lpost_tf_lo_s2:
 .byte 0x78, 0x99, 0x9f, 0x7e, 0x64, 0x85, 0x83, 0x62
 .byte 0xb9, 0x58, 0x5e, 0xbf, 0xa5, 0x44, 0x42, 0xa3
.Lpost_tf_hi_s2:
 .byte 0x00, 0xf3, 0x0d, 0xfe, 0xaf, 0x5c, 0xa2, 0x51
 .byte 0x49, 0xba, 0x44, 0xb7, 0xe6, 0x15, 0xeb, 0x18

.Lpost_tf_lo_s3:
 .byte 0x1e, 0x66, 0xe7, 0x9f, 0x19, 0x61, 0xe0, 0x98
 .byte 0x6e, 0x16, 0x97, 0xef, 0x69, 0x11, 0x90, 0xe8
.Lpost_tf_hi_s3:
 .byte 0x00, 0xfc, 0x43, 0xbf, 0xeb, 0x17, 0xa8, 0x54
 .byte 0x52, 0xae, 0x11, 0xed, 0xb9, 0x45, 0xfa, 0x06


.Linv_shift_row:
 .byte 0x00, 0x0d, 0x0a, 0x07, 0x04, 0x01, 0x0e, 0x0b
 .byte 0x08, 0x05, 0x02, 0x0f, 0x0c, 0x09, 0x06, 0x03


.align 4

.L0f0f0f0f:
 .long 0x0f0f0f0f

.text

.align 8

__camellia_enc_blk16:

 leaq 8 * 16(%rax), %rcx;

 vmovdqu %xmm11, (%rax); vmovdqu %xmm15, (%rcx); vpunpckhdq %xmm4, %xmm0, %xmm15; vpunpckldq %xmm4, %xmm0, %xmm0; vpunpckldq %xmm12, %xmm8, %xmm11; vpunpckhdq %xmm12, %xmm8, %xmm8; vpunpckhqdq %xmm11, %xmm0, %xmm4; vpunpcklqdq %xmm11, %xmm0, %xmm0; vpunpckhqdq %xmm8, %xmm15, %xmm12; vpunpcklqdq %xmm8, %xmm15, %xmm8;; vpunpckhdq %xmm5, %xmm1, %xmm15; vpunpckldq %xmm5, %xmm1, %xmm1; vpunpckldq %xmm13, %xmm9, %xmm11; vpunpckhdq %xmm13, %xmm9, %xmm9; vpunpckhqdq %xmm11, %xmm1, %xmm5; vpunpcklqdq %xmm11, %xmm1, %xmm1; vpunpckhqdq %xmm9, %xmm15, %xmm13; vpunpcklqdq %xmm9, %xmm15, %xmm9;; vmovdqu (%rax), %xmm11; vmovdqu (%rcx), %xmm15; vmovdqu %xmm0, (%rax); vmovdqu %xmm4, (%rcx); vpunpckhdq %xmm6, %xmm2, %xmm4; vpunpckldq %xmm6, %xmm2, %xmm2; vpunpckldq %xmm14, %xmm10, %xmm0; vpunpckhdq %xmm14, %xmm10, %xmm10; vpunpckhqdq %xmm0, %xmm2, %xmm6; vpunpcklqdq %xmm0, %xmm2, %xmm2; vpunpckhqdq %xmm10, %xmm4, %xmm14; vpunpcklqdq %xmm10, %xmm4, %xmm10;; vpunpckhdq %xmm7, %xmm3, %xmm4; vpunpckldq %xmm7, %xmm3, %xmm3; vpunpckldq %xmm15, %xmm11, %xmm0; vpunpckhdq %xmm15, %xmm11, %xmm11; vpunpckhqdq %xmm0, %xmm3, %xmm7; vpunpcklqdq %xmm0, %xmm3, %xmm3; vpunpckhqdq %xmm11, %xmm4, %xmm15; vpunpcklqdq %xmm11, %xmm4, %xmm11;; vmovdqu .Lshufb_16x16b(%rip), %xmm0; vmovdqu (%rcx), %xmm4; vpshufb %xmm0, %xmm8, %xmm8; vpshufb %xmm0, %xmm12, %xmm12; vpshufb %xmm0, %xmm1, %xmm1; vpshufb %xmm0, %xmm5, %xmm5; vpshufb %xmm0, %xmm9, %xmm9; vpshufb %xmm0, %xmm13, %xmm13; vpshufb %xmm0, %xmm4, %xmm4; vpshufb %xmm0, %xmm2, %xmm2; vpshufb %xmm0, %xmm6, %xmm6; vpshufb %xmm0, %xmm10, %xmm10; vpshufb %xmm0, %xmm14, %xmm14; vpshufb %xmm0, %xmm3, %xmm3; vpshufb %xmm0, %xmm7, %xmm7; vpshufb %xmm0, %xmm11, %xmm11; vpshufb %xmm0, %xmm15, %xmm15; vmovdqu %xmm15, (%rcx); vmovdqu (%rax), %xmm15; vpshufb %xmm0, %xmm15, %xmm0; vmovdqu %xmm11, (%rax); vpunpckhdq %xmm1, %xmm0, %xmm15; vpunpckldq %xmm1, %xmm0, %xmm0; vpunpckldq %xmm3, %xmm2, %xmm11; vpunpckhdq %xmm3, %xmm2, %xmm2; vpunpckhqdq %xmm11, %xmm0, %xmm1; vpunpcklqdq %xmm11, %xmm0, %xmm0; vpunpckhqdq %xmm2, %xmm15, %xmm3; vpunpcklqdq %xmm2, %xmm15, %xmm2;; vpunpckhdq %xmm5, %xmm4, %xmm15; vpunpckldq %xmm5, %xmm4, %xmm4; vpunpckldq %xmm7, %xmm6, %xmm11; vpunpckhdq %xmm7, %xmm6, %xmm6; vpunpckhqdq %xmm11, %xmm4, %xmm5; vpunpcklqdq %xmm11, %xmm4, %xmm4; vpunpckhqdq %xmm6, %xmm15, %xmm7; vpunpcklqdq %xmm6, %xmm15, %xmm6;; vmovdqu (%rax), %xmm11; vmovdqu (%rcx), %xmm15; vmovdqu %xmm1, (%rax); vmovdqu %xmm5, (%rcx); vpunpckhdq %xmm9, %xmm8, %xmm5; vpunpckldq %xmm9, %xmm8, %xmm8; vpunpckldq %xmm11, %xmm10, %xmm1; vpunpckhdq %xmm11, %xmm10, %xmm10; vpunpckhqdq %xmm1, %xmm8, %xmm9; vpunpcklqdq %xmm1, %xmm8, %xmm8; vpunpckhqdq %xmm10, %xmm5, %xmm11; vpunpcklqdq %xmm10, %xmm5, %xmm10;; vpunpckhdq %xmm13, %xmm12, %xmm5; vpunpckldq %xmm13, %xmm12, %xmm12; vpunpckldq %xmm15, %xmm14, %xmm1; vpunpckhdq %xmm15, %xmm14, %xmm14; vpunpckhqdq %xmm1, %xmm12, %xmm13; vpunpcklqdq %xmm1, %xmm12, %xmm12; vpunpckhqdq %xmm14, %xmm5, %xmm15; vpunpcklqdq %xmm14, %xmm5, %xmm14;; vmovdqu (%rax), %xmm1; vmovdqu (%rcx), %xmm5;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax); vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovdqu %xmm12, 4 * 16(%rcx); vmovdqu %xmm13, 5 * 16(%rcx); vmovdqu %xmm14, 6 * 16(%rcx); vmovdqu %xmm15, 7 * 16(%rcx);;



 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 2) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 2) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 4) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 4) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 6) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 6) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;



 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (8) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (8) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (8) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (8) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;







 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 2) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 2) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 4) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 4) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 6) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 6) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;



 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (16) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (16) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (16) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (16) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;







 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 2) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 2) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 4) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 4) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 6) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 6) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;

 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (24) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (24) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (24) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (24) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;

 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 2) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 2) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 4) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 4) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 6) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 6) + (1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;

 vmovdqu 0 * 16(%rcx), %xmm8;
 vmovdqu 1 * 16(%rcx), %xmm9;
 vmovdqu 2 * 16(%rcx), %xmm10;
 vmovdqu 3 * 16(%rcx), %xmm11;
 vmovdqu 4 * 16(%rcx), %xmm12;
 vmovdqu 5 * 16(%rcx), %xmm13;
 vmovdqu 6 * 16(%rcx), %xmm14;
 vmovdqu 7 * 16(%rcx), %xmm15;

 vmovdqu %xmm6, (%rax); vmovdqu %xmm7, 1 * 16(%rax); vpunpckhdq %xmm9, %xmm8, %xmm7; vpunpckldq %xmm9, %xmm8, %xmm8; vpunpckldq %xmm11, %xmm10, %xmm6; vpunpckhdq %xmm11, %xmm10, %xmm10; vpunpckhqdq %xmm6, %xmm8, %xmm9; vpunpcklqdq %xmm6, %xmm8, %xmm8; vpunpckhqdq %xmm10, %xmm7, %xmm11; vpunpcklqdq %xmm10, %xmm7, %xmm10;; vpunpckhdq %xmm13, %xmm12, %xmm7; vpunpckldq %xmm13, %xmm12, %xmm12; vpunpckldq %xmm15, %xmm14, %xmm6; vpunpckhdq %xmm15, %xmm14, %xmm14; vpunpckhqdq %xmm6, %xmm12, %xmm13; vpunpcklqdq %xmm6, %xmm12, %xmm12; vpunpckhqdq %xmm14, %xmm7, %xmm15; vpunpcklqdq %xmm14, %xmm7, %xmm14;; vmovdqu (%rax), %xmm6; vmovdqu 1 * 16(%rax), %xmm7; vmovdqu %xmm8, (%rax); vmovdqu %xmm9, 1 * 16(%rax); vpunpckhdq %xmm1, %xmm0, %xmm9; vpunpckldq %xmm1, %xmm0, %xmm0; vpunpckldq %xmm3, %xmm2, %xmm8; vpunpckhdq %xmm3, %xmm2, %xmm2; vpunpckhqdq %xmm8, %xmm0, %xmm1; vpunpcklqdq %xmm8, %xmm0, %xmm0; vpunpckhqdq %xmm2, %xmm9, %xmm3; vpunpcklqdq %xmm2, %xmm9, %xmm2;; vpunpckhdq %xmm5, %xmm4, %xmm9; vpunpckldq %xmm5, %xmm4, %xmm4; vpunpckldq %xmm7, %xmm6, %xmm8; vpunpckhdq %xmm7, %xmm6, %xmm6; vpunpckhqdq %xmm8, %xmm4, %xmm5; vpunpcklqdq %xmm8, %xmm4, %xmm4; vpunpckhqdq %xmm6, %xmm9, %xmm7; vpunpcklqdq %xmm6, %xmm9, %xmm6;; vmovdqu .Lshufb_16x16b(%rip), %xmm8; vmovdqu 1 * 16(%rax), %xmm9; vpshufb %xmm8, %xmm10, %xmm10; vpshufb %xmm8, %xmm11, %xmm11; vpshufb %xmm8, %xmm12, %xmm12; vpshufb %xmm8, %xmm13, %xmm13; vpshufb %xmm8, %xmm14, %xmm14; vpshufb %xmm8, %xmm15, %xmm15; vpshufb %xmm8, %xmm9, %xmm9; vpshufb %xmm8, %xmm0, %xmm0; vpshufb %xmm8, %xmm1, %xmm1; vpshufb %xmm8, %xmm2, %xmm2; vpshufb %xmm8, %xmm3, %xmm3; vpshufb %xmm8, %xmm4, %xmm4; vpshufb %xmm8, %xmm5, %xmm5; vpshufb %xmm8, %xmm6, %xmm6; vpshufb %xmm8, %xmm7, %xmm7; vmovdqu %xmm7, 1 * 16(%rax); vmovdqu (%rax), %xmm7; vpshufb %xmm8, %xmm7, %xmm8; vmovdqu %xmm6, (%rax); vpunpckhdq %xmm12, %xmm8, %xmm7; vpunpckldq %xmm12, %xmm8, %xmm8; vpunpckldq %xmm4, %xmm0, %xmm6; vpunpckhdq %xmm4, %xmm0, %xmm0; vpunpckhqdq %xmm6, %xmm8, %xmm12; vpunpcklqdq %xmm6, %xmm8, %xmm8; vpunpckhqdq %xmm0, %xmm7, %xmm4; vpunpcklqdq %xmm0, %xmm7, %xmm0;; vpunpckhdq %xmm13, %xmm9, %xmm7; vpunpckldq %xmm13, %xmm9, %xmm9; vpunpckldq %xmm5, %xmm1, %xmm6; vpunpckhdq %xmm5, %xmm1, %xmm1; vpunpckhqdq %xmm6, %xmm9, %xmm13; vpunpcklqdq %xmm6, %xmm9, %xmm9; vpunpckhqdq %xmm1, %xmm7, %xmm5; vpunpcklqdq %xmm1, %xmm7, %xmm1;; vmovdqu (%rax), %xmm6; vmovdqu 1 * 16(%rax), %xmm7; vmovdqu %xmm12, (%rax); vmovdqu %xmm13, 1 * 16(%rax); vpunpckhdq %xmm14, %xmm10, %xmm13; vpunpckldq %xmm14, %xmm10, %xmm10; vpunpckldq %xmm6, %xmm2, %xmm12; vpunpckhdq %xmm6, %xmm2, %xmm2; vpunpckhqdq %xmm12, %xmm10, %xmm14; vpunpcklqdq %xmm12, %xmm10, %xmm10; vpunpckhqdq %xmm2, %xmm13, %xmm6; vpunpcklqdq %xmm2, %xmm13, %xmm2;; vpunpckhdq %xmm15, %xmm11, %xmm13; vpunpckldq %xmm15, %xmm11, %xmm11; vpunpckldq %xmm7, %xmm3, %xmm12; vpunpckhdq %xmm7, %xmm3, %xmm3; vpunpckhqdq %xmm12, %xmm11, %xmm15; vpunpcklqdq %xmm12, %xmm11, %xmm11; vpunpckhqdq %xmm3, %xmm13, %xmm7; vpunpcklqdq %xmm3, %xmm13, %xmm3;; vmovdqu (%rax), %xmm12; vmovdqu 1 * 16(%rax), %xmm13;; vmovdqu %xmm0, (%rax); vmovq (256)(%rdi), %xmm0; vpshufb .Lpack_bswap(%rip), %xmm0, %xmm0; vpxor %xmm0, %xmm15, %xmm15; vpxor %xmm0, %xmm14, %xmm14; vpxor %xmm0, %xmm13, %xmm13; vpxor %xmm0, %xmm12, %xmm12; vpxor %xmm0, %xmm11, %xmm11; vpxor %xmm0, %xmm10, %xmm10; vpxor %xmm0, %xmm9, %xmm9; vpxor %xmm0, %xmm8, %xmm8; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm0, %xmm4, %xmm4; vpxor %xmm0, %xmm3, %xmm3; vpxor %xmm0, %xmm2, %xmm2; vpxor %xmm0, %xmm1, %xmm1; vpxor (%rax), %xmm0, %xmm0;;



 ret;


.align 8

__camellia_dec_blk16:

 leaq 8 * 16(%rax), %rcx;

 vmovdqu %xmm11, (%rax); vmovdqu %xmm15, (%rcx); vpunpckhdq %xmm4, %xmm0, %xmm15; vpunpckldq %xmm4, %xmm0, %xmm0; vpunpckldq %xmm12, %xmm8, %xmm11; vpunpckhdq %xmm12, %xmm8, %xmm8; vpunpckhqdq %xmm11, %xmm0, %xmm4; vpunpcklqdq %xmm11, %xmm0, %xmm0; vpunpckhqdq %xmm8, %xmm15, %xmm12; vpunpcklqdq %xmm8, %xmm15, %xmm8;; vpunpckhdq %xmm5, %xmm1, %xmm15; vpunpckldq %xmm5, %xmm1, %xmm1; vpunpckldq %xmm13, %xmm9, %xmm11; vpunpckhdq %xmm13, %xmm9, %xmm9; vpunpckhqdq %xmm11, %xmm1, %xmm5; vpunpcklqdq %xmm11, %xmm1, %xmm1; vpunpckhqdq %xmm9, %xmm15, %xmm13; vpunpcklqdq %xmm9, %xmm15, %xmm9;; vmovdqu (%rax), %xmm11; vmovdqu (%rcx), %xmm15; vmovdqu %xmm0, (%rax); vmovdqu %xmm4, (%rcx); vpunpckhdq %xmm6, %xmm2, %xmm4; vpunpckldq %xmm6, %xmm2, %xmm2; vpunpckldq %xmm14, %xmm10, %xmm0; vpunpckhdq %xmm14, %xmm10, %xmm10; vpunpckhqdq %xmm0, %xmm2, %xmm6; vpunpcklqdq %xmm0, %xmm2, %xmm2; vpunpckhqdq %xmm10, %xmm4, %xmm14; vpunpcklqdq %xmm10, %xmm4, %xmm10;; vpunpckhdq %xmm7, %xmm3, %xmm4; vpunpckldq %xmm7, %xmm3, %xmm3; vpunpckldq %xmm15, %xmm11, %xmm0; vpunpckhdq %xmm15, %xmm11, %xmm11; vpunpckhqdq %xmm0, %xmm3, %xmm7; vpunpcklqdq %xmm0, %xmm3, %xmm3; vpunpckhqdq %xmm11, %xmm4, %xmm15; vpunpcklqdq %xmm11, %xmm4, %xmm11;; vmovdqu .Lshufb_16x16b(%rip), %xmm0; vmovdqu (%rcx), %xmm4; vpshufb %xmm0, %xmm8, %xmm8; vpshufb %xmm0, %xmm12, %xmm12; vpshufb %xmm0, %xmm1, %xmm1; vpshufb %xmm0, %xmm5, %xmm5; vpshufb %xmm0, %xmm9, %xmm9; vpshufb %xmm0, %xmm13, %xmm13; vpshufb %xmm0, %xmm4, %xmm4; vpshufb %xmm0, %xmm2, %xmm2; vpshufb %xmm0, %xmm6, %xmm6; vpshufb %xmm0, %xmm10, %xmm10; vpshufb %xmm0, %xmm14, %xmm14; vpshufb %xmm0, %xmm3, %xmm3; vpshufb %xmm0, %xmm7, %xmm7; vpshufb %xmm0, %xmm11, %xmm11; vpshufb %xmm0, %xmm15, %xmm15; vmovdqu %xmm15, (%rcx); vmovdqu (%rax), %xmm15; vpshufb %xmm0, %xmm15, %xmm0; vmovdqu %xmm11, (%rax); vpunpckhdq %xmm1, %xmm0, %xmm15; vpunpckldq %xmm1, %xmm0, %xmm0; vpunpckldq %xmm3, %xmm2, %xmm11; vpunpckhdq %xmm3, %xmm2, %xmm2; vpunpckhqdq %xmm11, %xmm0, %xmm1; vpunpcklqdq %xmm11, %xmm0, %xmm0; vpunpckhqdq %xmm2, %xmm15, %xmm3; vpunpcklqdq %xmm2, %xmm15, %xmm2;; vpunpckhdq %xmm5, %xmm4, %xmm15; vpunpckldq %xmm5, %xmm4, %xmm4; vpunpckldq %xmm7, %xmm6, %xmm11; vpunpckhdq %xmm7, %xmm6, %xmm6; vpunpckhqdq %xmm11, %xmm4, %xmm5; vpunpcklqdq %xmm11, %xmm4, %xmm4; vpunpckhqdq %xmm6, %xmm15, %xmm7; vpunpcklqdq %xmm6, %xmm15, %xmm6;; vmovdqu (%rax), %xmm11; vmovdqu (%rcx), %xmm15; vmovdqu %xmm1, (%rax); vmovdqu %xmm5, (%rcx); vpunpckhdq %xmm9, %xmm8, %xmm5; vpunpckldq %xmm9, %xmm8, %xmm8; vpunpckldq %xmm11, %xmm10, %xmm1; vpunpckhdq %xmm11, %xmm10, %xmm10; vpunpckhqdq %xmm1, %xmm8, %xmm9; vpunpcklqdq %xmm1, %xmm8, %xmm8; vpunpckhqdq %xmm10, %xmm5, %xmm11; vpunpcklqdq %xmm10, %xmm5, %xmm10;; vpunpckhdq %xmm13, %xmm12, %xmm5; vpunpckldq %xmm13, %xmm12, %xmm12; vpunpckldq %xmm15, %xmm14, %xmm1; vpunpckhdq %xmm15, %xmm14, %xmm14; vpunpckhqdq %xmm1, %xmm12, %xmm13; vpunpcklqdq %xmm1, %xmm12, %xmm12; vpunpckhqdq %xmm14, %xmm5, %xmm15; vpunpcklqdq %xmm14, %xmm5, %xmm14;; vmovdqu (%rax), %xmm1; vmovdqu (%rcx), %xmm5;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax); vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovdqu %xmm12, 4 * 16(%rcx); vmovdqu %xmm13, 5 * 16(%rcx); vmovdqu %xmm14, 6 * 16(%rcx); vmovdqu %xmm15, 7 * 16(%rcx);;



 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 7) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 7) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 5) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 5) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((24) + 3) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((24) + 3) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;

 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (24) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (24) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (24) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (24) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;


 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 7) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 7) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 5) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 5) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((16) + 3) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((16) + 3) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;



 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (16) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (16) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (16) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (16) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;







 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 7) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 7) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 5) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 5) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((8) + 3) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((8) + 3) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;



 vpxor %xmm12, %xmm12, %xmm12; vmovd ((0 + (8) * 8) + 8)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand %xmm0, %xmm8, %xmm8; vpand %xmm1, %xmm9, %xmm9; vpand %xmm2, %xmm10, %xmm10; vpand %xmm3, %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor %xmm4, %xmm8, %xmm4; vmovdqu %xmm4, 4 * 16(%rax); vpxor %xmm5, %xmm9, %xmm5; vmovdqu %xmm5, 5 * 16(%rax); vpxor %xmm6, %xmm10, %xmm6; vmovdqu %xmm6, 6 * 16(%rax); vpxor %xmm7, %xmm11, %xmm7; vmovdqu %xmm7, 7 * 16(%rax); vmovd ((0 + (8) * 8) + 4)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor 4 * 16(%rcx), %xmm8, %xmm8; vpor 5 * 16(%rcx), %xmm9, %xmm9; vpor 6 * 16(%rcx), %xmm10, %xmm10; vpor 7 * 16(%rcx), %xmm11, %xmm11; vpxor 0 * 16(%rcx), %xmm8, %xmm8; vpxor 1 * 16(%rcx), %xmm9, %xmm9; vpxor 2 * 16(%rcx), %xmm10, %xmm10; vpxor 3 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 0 * 16(%rcx); vmovdqu %xmm9, 1 * 16(%rcx); vmovdqu %xmm10, 2 * 16(%rcx); vmovdqu %xmm11, 3 * 16(%rcx); vmovd ((0 + (8) * 8) + 0)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpand 0 * 16(%rcx), %xmm8, %xmm8; vpand 1 * 16(%rcx), %xmm9, %xmm9; vpand 2 * 16(%rcx), %xmm10, %xmm10; vpand 3 * 16(%rcx), %xmm11, %xmm11; vpcmpgtb %xmm11, %xmm12, %xmm13; vpaddb %xmm11, %xmm11, %xmm11; vpabsb %xmm13, %xmm13; vpcmpgtb %xmm10, %xmm12, %xmm14; vpaddb %xmm10, %xmm10, %xmm10; vpabsb %xmm14, %xmm14; vpcmpgtb %xmm9, %xmm12, %xmm15; vpaddb %xmm9, %xmm9, %xmm9; vpabsb %xmm15, %xmm15; vpor %xmm13, %xmm10, %xmm10; vpcmpgtb %xmm8, %xmm12, %xmm13; vpaddb %xmm8, %xmm8, %xmm8; vpabsb %xmm13, %xmm13; vpor %xmm14, %xmm9, %xmm9; vpor %xmm15, %xmm8, %xmm8; vpor %xmm13, %xmm11, %xmm11;; vpxor 4 * 16(%rcx), %xmm8, %xmm8; vpxor 5 * 16(%rcx), %xmm9, %xmm9; vpxor 6 * 16(%rcx), %xmm10, %xmm10; vpxor 7 * 16(%rcx), %xmm11, %xmm11; vmovdqu %xmm8, 4 * 16(%rcx); vmovdqu %xmm9, 5 * 16(%rcx); vmovdqu %xmm10, 6 * 16(%rcx); vmovdqu %xmm11, 7 * 16(%rcx); vmovd ((0 + (8) * 8) + 12)(%rdi), %xmm8; vpshufb %xmm12, %xmm8, %xmm11; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm10; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm9; vpsrldq $1, %xmm8, %xmm8; vpshufb %xmm12, %xmm8, %xmm8; vpor %xmm4, %xmm8, %xmm8; vpor %xmm5, %xmm9, %xmm9; vpor %xmm6, %xmm10, %xmm10; vpor %xmm7, %xmm11, %xmm11; vpxor %xmm0, %xmm8, %xmm0; vmovdqu %xmm0, 0 * 16(%rax); vpxor %xmm1, %xmm9, %xmm1; vmovdqu %xmm1, 1 * 16(%rax); vpxor %xmm2, %xmm10, %xmm2; vmovdqu %xmm2, 2 * 16(%rax); vpxor %xmm3, %xmm11, %xmm3; vmovdqu %xmm3, 3 * 16(%rax);;







 vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 7) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 7) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 5) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 5) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; vmovdqu %xmm0, 0 * 16(%rax); vmovdqu %xmm1, 1 * 16(%rax); vmovdqu %xmm2, 2 * 16(%rax); vmovdqu %xmm3, 3 * 16(%rax); vmovdqu %xmm4, 4 * 16(%rax); vmovdqu %xmm5, 5 * 16(%rax); vmovdqu %xmm6, 6 * 16(%rax); vmovdqu %xmm7, 7 * 16(%rax);;; vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm2, %xmm2; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm6, %xmm6; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm3, %xmm11, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm2, %xmm2; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm6, %xmm6; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm5, %xmm11, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + ((0) + 3) * 8)(%rdi), %xmm8; vpand %xmm1, %xmm15, %xmm10; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm1, %xmm13, %xmm1; vpxor %xmm10, %xmm1, %xmm1;; vpand %xmm4, %xmm15, %xmm10; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm4, %xmm13, %xmm4; vpxor %xmm10, %xmm4, %xmm4;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm5, %xmm0, %xmm0; vpxor %xmm6, %xmm1, %xmm1; vpxor %xmm7, %xmm2, %xmm2; vpxor %xmm4, %xmm3, %xmm3; vpxor %xmm2, %xmm4, %xmm4; vpxor %xmm3, %xmm5, %xmm5; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm1, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm11, %xmm4, %xmm4; vpxor 0 * 16(%rcx), %xmm4, %xmm4; vpxor %xmm10, %xmm5, %xmm5; vpxor 1 * 16(%rcx), %xmm5, %xmm5; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm6, %xmm6; vpxor 2 * 16(%rcx), %xmm6, %xmm6; vpxor %xmm8, %xmm7, %xmm7; vpxor 3 * 16(%rcx), %xmm7, %xmm7; vpxor %xmm15, %xmm0, %xmm0; vpxor 4 * 16(%rcx), %xmm0, %xmm0; vpxor %xmm14, %xmm1, %xmm1; vpxor 5 * 16(%rcx), %xmm1, %xmm1; vpxor %xmm13, %xmm2, %xmm2; vpxor 6 * 16(%rcx), %xmm2, %xmm2; vpxor %xmm12, %xmm3, %xmm3; vpxor 7 * 16(%rcx), %xmm3, %xmm3;; vmovdqu %xmm4, 0 * 16(%rcx); vmovdqu %xmm5, 1 * 16(%rcx); vmovdqu %xmm6, 2 * 16(%rcx); vmovdqu %xmm7, 3 * 16(%rcx); vmovdqu %xmm0, 4 * 16(%rcx); vmovdqu %xmm1, 5 * 16(%rcx); vmovdqu %xmm2, 6 * 16(%rcx); vmovdqu %xmm3, 7 * 16(%rcx); vmovdqu .Linv_shift_row(%rip), %xmm12; vbroadcastss .L0f0f0f0f(%rip), %xmm15; vmovdqu .Lpre_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpre_tf_hi_s1(%rip), %xmm9; vpshufb %xmm12, %xmm4, %xmm4; vpshufb %xmm12, %xmm3, %xmm3; vpshufb %xmm12, %xmm5, %xmm5; vpshufb %xmm12, %xmm0, %xmm0; vpshufb %xmm12, %xmm6, %xmm6; vpshufb %xmm12, %xmm1, %xmm1; vpshufb %xmm12, %xmm7, %xmm7; vpshufb %xmm12, %xmm2, %xmm2; vmovdqu .Lpre_tf_lo_s4(%rip), %xmm10; vmovdqu .Lpre_tf_hi_s4(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm5, %xmm15, %xmm14; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm5, %xmm9, %xmm5; vpxor %xmm14, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm14; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm0, %xmm9, %xmm0; vpxor %xmm14, %xmm0, %xmm0;; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm6, %xmm9, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm1, %xmm9, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm12, %xmm12, %xmm12; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm7, %xmm11, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm2, %xmm11, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s1(%rip), %xmm8; vmovdqu .Lpost_tf_hi_s1(%rip), %xmm9; vaesenclast %xmm12, %xmm4, %xmm4; vaesenclast %xmm12, %xmm3, %xmm3; vaesenclast %xmm12, %xmm5, %xmm5; vaesenclast %xmm12, %xmm0, %xmm0; vaesenclast %xmm12, %xmm6, %xmm6; vaesenclast %xmm12, %xmm1, %xmm1; vaesenclast %xmm12, %xmm7, %xmm7; vaesenclast %xmm12, %xmm2, %xmm2; vmovdqu .Lpost_tf_lo_s3(%rip), %xmm10; vmovdqu .Lpost_tf_hi_s3(%rip), %xmm11; vpand %xmm4, %xmm15, %xmm14; vpandn %xmm4, %xmm15, %xmm4; vpsrld $4, %xmm4, %xmm4; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm4, %xmm9, %xmm4; vpxor %xmm14, %xmm4, %xmm4;; vpand %xmm3, %xmm15, %xmm14; vpandn %xmm3, %xmm15, %xmm3; vpsrld $4, %xmm3, %xmm3; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm3, %xmm9, %xmm3; vpxor %xmm14, %xmm3, %xmm3;; vpand %xmm7, %xmm15, %xmm14; vpandn %xmm7, %xmm15, %xmm7; vpsrld $4, %xmm7, %xmm7; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm7, %xmm9, %xmm7; vpxor %xmm14, %xmm7, %xmm7;; vpand %xmm2, %xmm15, %xmm14; vpandn %xmm2, %xmm15, %xmm2; vpsrld $4, %xmm2, %xmm2; vpshufb %xmm14, %xmm8, %xmm14; vpshufb %xmm2, %xmm9, %xmm2; vpxor %xmm14, %xmm2, %xmm2;; vmovdqu .Lpost_tf_lo_s2(%rip), %xmm12; vmovdqu .Lpost_tf_hi_s2(%rip), %xmm13; vpand %xmm6, %xmm15, %xmm14; vpandn %xmm6, %xmm15, %xmm6; vpsrld $4, %xmm6, %xmm6; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm6, %xmm11, %xmm6; vpxor %xmm14, %xmm6, %xmm6;; vpand %xmm1, %xmm15, %xmm14; vpandn %xmm1, %xmm15, %xmm1; vpsrld $4, %xmm1, %xmm1; vpshufb %xmm14, %xmm10, %xmm14; vpshufb %xmm1, %xmm11, %xmm1; vpxor %xmm14, %xmm1, %xmm1;; vpxor %xmm14, %xmm14, %xmm14; vmovq (0 + (((0) + 3) + (-1)) * 8)(%rdi), %xmm8; vpand %xmm5, %xmm15, %xmm10; vpandn %xmm5, %xmm15, %xmm5; vpsrld $4, %xmm5, %xmm5; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm5, %xmm13, %xmm5; vpxor %xmm10, %xmm5, %xmm5;; vpand %xmm0, %xmm15, %xmm10; vpandn %xmm0, %xmm15, %xmm0; vpsrld $4, %xmm0, %xmm0; vpshufb %xmm10, %xmm12, %xmm10; vpshufb %xmm0, %xmm13, %xmm0; vpxor %xmm10, %xmm0, %xmm0;; vpsrldq $5, %xmm8, %xmm13; vpsrldq $1, %xmm8, %xmm9; vpsrldq $2, %xmm8, %xmm10; vpsrldq $3, %xmm8, %xmm11; vpsrldq $4, %xmm8, %xmm12; vpshufb %xmm14, %xmm8, %xmm8; vpshufb %xmm14, %xmm9, %xmm9; vpshufb %xmm14, %xmm10, %xmm10; vpshufb %xmm14, %xmm11, %xmm11; vpshufb %xmm14, %xmm12, %xmm12; vpsrldq $2, %xmm13, %xmm15; vpshufb %xmm14, %xmm15, %xmm15; vpxor %xmm1, %xmm4, %xmm4; vpxor %xmm2, %xmm5, %xmm5; vpxor %xmm3, %xmm6, %xmm6; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm6, %xmm0, %xmm0; vpxor %xmm7, %xmm1, %xmm1; vpxor %xmm4, %xmm2, %xmm2; vpxor %xmm5, %xmm3, %xmm3; vpxor %xmm3, %xmm4, %xmm4; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm1, %xmm6, %xmm6; vpxor %xmm2, %xmm7, %xmm7; vpxor %xmm7, %xmm0, %xmm0; vpxor %xmm4, %xmm1, %xmm1; vpxor %xmm5, %xmm2, %xmm2; vpxor %xmm6, %xmm3, %xmm3; vpxor %xmm11, %xmm0, %xmm0; vpxor 0 * 16(%rax), %xmm0, %xmm0; vpxor %xmm10, %xmm1, %xmm1; vpxor 1 * 16(%rax), %xmm1, %xmm1; vpsrldq $1, %xmm13, %xmm11; vpshufb %xmm14, %xmm13, %xmm13; vpshufb %xmm14, %xmm11, %xmm14; vpxor %xmm9, %xmm2, %xmm2; vpxor 2 * 16(%rax), %xmm2, %xmm2; vpxor %xmm8, %xmm3, %xmm3; vpxor 3 * 16(%rax), %xmm3, %xmm3; vpxor %xmm15, %xmm4, %xmm4; vpxor 4 * 16(%rax), %xmm4, %xmm4; vpxor %xmm14, %xmm5, %xmm5; vpxor 5 * 16(%rax), %xmm5, %xmm5; vpxor %xmm13, %xmm6, %xmm6; vpxor 6 * 16(%rax), %xmm6, %xmm6; vpxor %xmm12, %xmm7, %xmm7; vpxor 7 * 16(%rax), %xmm7, %xmm7;; ;;;




 vmovdqu 0 * 16(%rcx), %xmm8;
 vmovdqu 1 * 16(%rcx), %xmm9;
 vmovdqu 2 * 16(%rcx), %xmm10;
 vmovdqu 3 * 16(%rcx), %xmm11;
 vmovdqu 4 * 16(%rcx), %xmm12;
 vmovdqu 5 * 16(%rcx), %xmm13;
 vmovdqu 6 * 16(%rcx), %xmm14;
 vmovdqu 7 * 16(%rcx), %xmm15;

 vmovdqu %xmm6, (%rax); vmovdqu %xmm7, 1 * 16(%rax); vpunpckhdq %xmm9, %xmm8, %xmm7; vpunpckldq %xmm9, %xmm8, %xmm8; vpunpckldq %xmm11, %xmm10, %xmm6; vpunpckhdq %xmm11, %xmm10, %xmm10; vpunpckhqdq %xmm6, %xmm8, %xmm9; vpunpcklqdq %xmm6, %xmm8, %xmm8; vpunpckhqdq %xmm10, %xmm7, %xmm11; vpunpcklqdq %xmm10, %xmm7, %xmm10;; vpunpckhdq %xmm13, %xmm12, %xmm7; vpunpckldq %xmm13, %xmm12, %xmm12; vpunpckldq %xmm15, %xmm14, %xmm6; vpunpckhdq %xmm15, %xmm14, %xmm14; vpunpckhqdq %xmm6, %xmm12, %xmm13; vpunpcklqdq %xmm6, %xmm12, %xmm12; vpunpckhqdq %xmm14, %xmm7, %xmm15; vpunpcklqdq %xmm14, %xmm7, %xmm14;; vmovdqu (%rax), %xmm6; vmovdqu 1 * 16(%rax), %xmm7; vmovdqu %xmm8, (%rax); vmovdqu %xmm9, 1 * 16(%rax); vpunpckhdq %xmm1, %xmm0, %xmm9; vpunpckldq %xmm1, %xmm0, %xmm0; vpunpckldq %xmm3, %xmm2, %xmm8; vpunpckhdq %xmm3, %xmm2, %xmm2; vpunpckhqdq %xmm8, %xmm0, %xmm1; vpunpcklqdq %xmm8, %xmm0, %xmm0; vpunpckhqdq %xmm2, %xmm9, %xmm3; vpunpcklqdq %xmm2, %xmm9, %xmm2;; vpunpckhdq %xmm5, %xmm4, %xmm9; vpunpckldq %xmm5, %xmm4, %xmm4; vpunpckldq %xmm7, %xmm6, %xmm8; vpunpckhdq %xmm7, %xmm6, %xmm6; vpunpckhqdq %xmm8, %xmm4, %xmm5; vpunpcklqdq %xmm8, %xmm4, %xmm4; vpunpckhqdq %xmm6, %xmm9, %xmm7; vpunpcklqdq %xmm6, %xmm9, %xmm6;; vmovdqu .Lshufb_16x16b(%rip), %xmm8; vmovdqu 1 * 16(%rax), %xmm9; vpshufb %xmm8, %xmm10, %xmm10; vpshufb %xmm8, %xmm11, %xmm11; vpshufb %xmm8, %xmm12, %xmm12; vpshufb %xmm8, %xmm13, %xmm13; vpshufb %xmm8, %xmm14, %xmm14; vpshufb %xmm8, %xmm15, %xmm15; vpshufb %xmm8, %xmm9, %xmm9; vpshufb %xmm8, %xmm0, %xmm0; vpshufb %xmm8, %xmm1, %xmm1; vpshufb %xmm8, %xmm2, %xmm2; vpshufb %xmm8, %xmm3, %xmm3; vpshufb %xmm8, %xmm4, %xmm4; vpshufb %xmm8, %xmm5, %xmm5; vpshufb %xmm8, %xmm6, %xmm6; vpshufb %xmm8, %xmm7, %xmm7; vmovdqu %xmm7, 1 * 16(%rax); vmovdqu (%rax), %xmm7; vpshufb %xmm8, %xmm7, %xmm8; vmovdqu %xmm6, (%rax); vpunpckhdq %xmm12, %xmm8, %xmm7; vpunpckldq %xmm12, %xmm8, %xmm8; vpunpckldq %xmm4, %xmm0, %xmm6; vpunpckhdq %xmm4, %xmm0, %xmm0; vpunpckhqdq %xmm6, %xmm8, %xmm12; vpunpcklqdq %xmm6, %xmm8, %xmm8; vpunpckhqdq %xmm0, %xmm7, %xmm4; vpunpcklqdq %xmm0, %xmm7, %xmm0;; vpunpckhdq %xmm13, %xmm9, %xmm7; vpunpckldq %xmm13, %xmm9, %xmm9; vpunpckldq %xmm5, %xmm1, %xmm6; vpunpckhdq %xmm5, %xmm1, %xmm1; vpunpckhqdq %xmm6, %xmm9, %xmm13; vpunpcklqdq %xmm6, %xmm9, %xmm9; vpunpckhqdq %xmm1, %xmm7, %xmm5; vpunpcklqdq %xmm1, %xmm7, %xmm1;; vmovdqu (%rax), %xmm6; vmovdqu 1 * 16(%rax), %xmm7; vmovdqu %xmm12, (%rax); vmovdqu %xmm13, 1 * 16(%rax); vpunpckhdq %xmm14, %xmm10, %xmm13; vpunpckldq %xmm14, %xmm10, %xmm10; vpunpckldq %xmm6, %xmm2, %xmm12; vpunpckhdq %xmm6, %xmm2, %xmm2; vpunpckhqdq %xmm12, %xmm10, %xmm14; vpunpcklqdq %xmm12, %xmm10, %xmm10; vpunpckhqdq %xmm2, %xmm13, %xmm6; vpunpcklqdq %xmm2, %xmm13, %xmm2;; vpunpckhdq %xmm15, %xmm11, %xmm13; vpunpckldq %xmm15, %xmm11, %xmm11; vpunpckldq %xmm7, %xmm3, %xmm12; vpunpckhdq %xmm7, %xmm3, %xmm3; vpunpckhqdq %xmm12, %xmm11, %xmm15; vpunpcklqdq %xmm12, %xmm11, %xmm11; vpunpckhqdq %xmm3, %xmm13, %xmm7; vpunpcklqdq %xmm3, %xmm13, %xmm3;; vmovdqu (%rax), %xmm12; vmovdqu 1 * 16(%rax), %xmm13;; vmovdqu %xmm0, (%rax); vmovq (0)(%rdi), %xmm0; vpshufb .Lpack_bswap(%rip), %xmm0, %xmm0; vpxor %xmm0, %xmm15, %xmm15; vpxor %xmm0, %xmm14, %xmm14; vpxor %xmm0, %xmm13, %xmm13; vpxor %xmm0, %xmm12, %xmm12; vpxor %xmm0, %xmm11, %xmm11; vpxor %xmm0, %xmm10, %xmm10; vpxor %xmm0, %xmm9, %xmm9; vpxor %xmm0, %xmm8, %xmm8; vpxor %xmm0, %xmm7, %xmm7; vpxor %xmm0, %xmm6, %xmm6; vpxor %xmm0, %xmm5, %xmm5; vpxor %xmm0, %xmm4, %xmm4; vpxor %xmm0, %xmm3, %xmm3; vpxor %xmm0, %xmm2, %xmm2; vpxor %xmm0, %xmm1, %xmm1; vpxor (%rax), %xmm0, %xmm0;;



 ret;

.align 8
.global camellia_ecb_enc_16way
.global _camellia_ecb_enc_16way

camellia_ecb_enc_16way:
_camellia_ecb_enc_16way:

.ifdef WINABI
pushq %rsi
pushq %rdi
subq $168, %rsp # 8 bytes to align stack and 16*10 bytes to store xmm register
vmovdqa	%xmm6, 0*16 (%rsp)
vmovdqa	%xmm7, 1*16 (%rsp)
vmovdqa	%xmm8, 2*16 (%rsp)
vmovdqa	%xmm9, 3*16 (%rsp)
vmovdqa	%xmm10, 4*16 (%rsp)
vmovdqa	%xmm11, 5*16 (%rsp)
vmovdqa	%xmm12, 6*16 (%rsp)
vmovdqa	%xmm13, 7*16 (%rsp)
vmovdqa	%xmm14, 8*16 (%rsp)
vmovdqa	%xmm15, 9*16 (%rsp)

movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif


 vzeroupper;
 vmovq (0)(%rdi), %xmm0; vpshufb .Lpack_bswap(%rip), %xmm0, %xmm0; vpxor 0 * 16(%rdx), %xmm0, %xmm15; vpxor 1 * 16(%rdx), %xmm0, %xmm14; vpxor 2 * 16(%rdx), %xmm0, %xmm13; vpxor 3 * 16(%rdx), %xmm0, %xmm12; vpxor 4 * 16(%rdx), %xmm0, %xmm11; vpxor 5 * 16(%rdx), %xmm0, %xmm10; vpxor 6 * 16(%rdx), %xmm0, %xmm9; vpxor 7 * 16(%rdx), %xmm0, %xmm8; vpxor 8 * 16(%rdx), %xmm0, %xmm7; vpxor 9 * 16(%rdx), %xmm0, %xmm6; vpxor 10 * 16(%rdx), %xmm0, %xmm5; vpxor 11 * 16(%rdx), %xmm0, %xmm4; vpxor 12 * 16(%rdx), %xmm0, %xmm3; vpxor 13 * 16(%rdx), %xmm0, %xmm2; vpxor 14 * 16(%rdx), %xmm0, %xmm1; vpxor 15 * 16(%rdx), %xmm0, %xmm0;;




 movq %rsi, %rax;

 call __camellia_enc_blk16;

 vmovdqu %xmm7, 0 * 16(%rsi); vmovdqu %xmm6, 1 * 16(%rsi); vmovdqu %xmm5, 2 * 16(%rsi); vmovdqu %xmm4, 3 * 16(%rsi); vmovdqu %xmm3, 4 * 16(%rsi); vmovdqu %xmm2, 5 * 16(%rsi); vmovdqu %xmm1, 6 * 16(%rsi); vmovdqu %xmm0, 7 * 16(%rsi); vmovdqu %xmm15, 8 * 16(%rsi); vmovdqu %xmm14, 9 * 16(%rsi); vmovdqu %xmm13, 10 * 16(%rsi); vmovdqu %xmm12, 11 * 16(%rsi); vmovdqu %xmm11, 12 * 16(%rsi); vmovdqu %xmm10, 13 * 16(%rsi); vmovdqu %xmm9, 14 * 16(%rsi); vmovdqu %xmm8, 15 * 16(%rsi);;



 vzeroupper;

.ifdef WINABI

vmovdqa	0*16 (%rsp), %xmm6
vmovdqa	1*16 (%rsp), %xmm7
vmovdqa	2*16 (%rsp), %xmm8
vmovdqa	3*16 (%rsp), %xmm9
vmovdqa	4*16 (%rsp), %xmm10
vmovdqa	5*16 (%rsp), %xmm11
vmovdqa	6*16 (%rsp), %xmm12
vmovdqa	7*16 (%rsp), %xmm13
vmovdqa	8*16 (%rsp), %xmm14
vmovdqa	9*16 (%rsp), %xmm15

addq $168, %rsp

popq %rdi
popq %rsi
.endif

 ret;

.align 8
.global camellia_ecb_dec_16way
.global _camellia_ecb_dec_16way

camellia_ecb_dec_16way:
_camellia_ecb_dec_16way:

.ifdef WINABI
pushq %rsi
pushq %rdi
subq $168, %rsp # 8 bytes to align stack and 16*10 bytes to store xmm register
vmovdqa	%xmm6, 0*16 (%rsp)
vmovdqa	%xmm7, 1*16 (%rsp)
vmovdqa	%xmm8, 2*16 (%rsp)
vmovdqa	%xmm9, 3*16 (%rsp)
vmovdqa	%xmm10, 4*16 (%rsp)
vmovdqa	%xmm11, 5*16 (%rsp)
vmovdqa	%xmm12, 6*16 (%rsp)
vmovdqa	%xmm13, 7*16 (%rsp)
vmovdqa	%xmm14, 8*16 (%rsp)
vmovdqa	%xmm15, 9*16 (%rsp)

movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif


 vzeroupper;


 vmovq (256)(%rdi), %xmm0; vpshufb .Lpack_bswap(%rip), %xmm0, %xmm0; vpxor 0 * 16(%rdx), %xmm0, %xmm15; vpxor 1 * 16(%rdx), %xmm0, %xmm14; vpxor 2 * 16(%rdx), %xmm0, %xmm13; vpxor 3 * 16(%rdx), %xmm0, %xmm12; vpxor 4 * 16(%rdx), %xmm0, %xmm11; vpxor 5 * 16(%rdx), %xmm0, %xmm10; vpxor 6 * 16(%rdx), %xmm0, %xmm9; vpxor 7 * 16(%rdx), %xmm0, %xmm8; vpxor 8 * 16(%rdx), %xmm0, %xmm7; vpxor 9 * 16(%rdx), %xmm0, %xmm6; vpxor 10 * 16(%rdx), %xmm0, %xmm5; vpxor 11 * 16(%rdx), %xmm0, %xmm4; vpxor 12 * 16(%rdx), %xmm0, %xmm3; vpxor 13 * 16(%rdx), %xmm0, %xmm2; vpxor 14 * 16(%rdx), %xmm0, %xmm1; vpxor 15 * 16(%rdx), %xmm0, %xmm0;;



 movq %rsi, %rax;

 call __camellia_dec_blk16;

 vmovdqu %xmm7, 0 * 16(%rsi); vmovdqu %xmm6, 1 * 16(%rsi); vmovdqu %xmm5, 2 * 16(%rsi); vmovdqu %xmm4, 3 * 16(%rsi); vmovdqu %xmm3, 4 * 16(%rsi); vmovdqu %xmm2, 5 * 16(%rsi); vmovdqu %xmm1, 6 * 16(%rsi); vmovdqu %xmm0, 7 * 16(%rsi); vmovdqu %xmm15, 8 * 16(%rsi); vmovdqu %xmm14, 9 * 16(%rsi); vmovdqu %xmm13, 10 * 16(%rsi); vmovdqu %xmm12, 11 * 16(%rsi); vmovdqu %xmm11, 12 * 16(%rsi); vmovdqu %xmm10, 13 * 16(%rsi); vmovdqu %xmm9, 14 * 16(%rsi); vmovdqu %xmm8, 15 * 16(%rsi);;



 vzeroupper;

.ifdef WINABI
vmovdqa	0*16 (%rsp), %xmm6
vmovdqa	1*16 (%rsp), %xmm7
vmovdqa	2*16 (%rsp), %xmm8
vmovdqa	3*16 (%rsp), %xmm9
vmovdqa	4*16 (%rsp), %xmm10
vmovdqa	5*16 (%rsp), %xmm11
vmovdqa	6*16 (%rsp), %xmm12
vmovdqa	7*16 (%rsp), %xmm13
vmovdqa	8*16 (%rsp), %xmm14
vmovdqa	9*16 (%rsp), %xmm15

addq $168, %rsp

popq %rdi
popq %rsi
.endif

 ret;

 .ifndef __YASM__
#if defined(__linux__) && defined(__ELF__)
.section .note.GNU-stack,"",%progbits
#endif
 .endif

